/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SecurityServiceType {
    WAF("WAF"),
    WAFV2("WAFV2"),
    SHIELD_ADVANCED("SHIELD_ADVANCED"),
    SECURITY_GROUPS_COMMON("SECURITY_GROUPS_COMMON"),
    SECURITY_GROUPS_CONTENT_AUDIT("SECURITY_GROUPS_CONTENT_AUDIT"),
    SECURITY_GROUPS_USAGE_AUDIT("SECURITY_GROUPS_USAGE_AUDIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SecurityServiceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityServiceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SecurityServiceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityServiceType> knownValues() {
        return Stream.of(SecurityServiceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

