/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fms.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProtectionStatusRequest extends FmsRequest implements
        ToCopyableBuilder<GetProtectionStatusRequest.Builder, GetProtectionStatusRequest> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetProtectionStatusRequest::policyId)).setter(setter(Builder::policyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()).build();

    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetProtectionStatusRequest::memberAccountId)).setter(setter(Builder::memberAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccountId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetProtectionStatusRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetProtectionStatusRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetProtectionStatusRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetProtectionStatusRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD,
            MEMBER_ACCOUNT_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String policyId;

    private final String memberAccountId;

    private final Instant startTime;

    private final Instant endTime;

    private final String nextToken;

    private final Integer maxResults;

    private GetProtectionStatusRequest(BuilderImpl builder) {
        super(builder);
        this.policyId = builder.policyId;
        this.memberAccountId = builder.memberAccountId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the policy for which you want to get the attack information.
     * </p>
     * 
     * @return The ID of the policy for which you want to get the attack information.
     */
    public String policyId() {
        return policyId;
    }

    /**
     * <p>
     * The AWS account that is in scope of the policy that you want to get the details for.
     * </p>
     * 
     * @return The AWS account that is in scope of the policy that you want to get the details for.
     */
    public String memberAccountId() {
        return memberAccountId;
    }

    /**
     * <p>
     * The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax
     * listing indicates a <code>number</code> type because the default used by AWS Firewall Manager is Unix time in
     * seconds. However, any valid <code>timestamp</code> format is allowed.
     * </p>
     * 
     * @return The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The request
     *         syntax listing indicates a <code>number</code> type because the default used by AWS Firewall Manager is
     *         Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The request syntax
     * listing indicates a <code>number</code> type because the default used by AWS Firewall Manager is Unix time in
     * seconds. However, any valid <code>timestamp</code> format is allowed.
     * </p>
     * 
     * @return The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The request
     *         syntax listing indicates a <code>number</code> type because the default used by AWS Firewall Manager is
     *         Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * If you specify a value for <code>MaxResults</code> and you have more objects than the number that you specify for
     * <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value in the response, which you
     * can use to retrieve another group of objects. For the second and subsequent <code>GetProtectionStatus</code>
     * requests, specify the value of <code>NextToken</code> from the previous response to get information about another
     * batch of objects.
     * </p>
     * 
     * @return If you specify a value for <code>MaxResults</code> and you have more objects than the number that you
     *         specify for <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value in the
     *         response, which you can use to retrieve another group of objects. For the second and subsequent
     *         <code>GetProtectionStatus</code> requests, specify the value of <code>NextToken</code> from the previous
     *         response to get information about another batch of objects.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the number of objects that you want AWS Firewall Manager to return for this request. If you have more
     * objects than the number that you specify for <code>MaxResults</code>, the response includes a
     * <code>NextToken</code> value that you can use to get another batch of objects.
     * </p>
     * 
     * @return Specifies the number of objects that you want AWS Firewall Manager to return for this request. If you
     *         have more objects than the number that you specify for <code>MaxResults</code>, the response includes a
     *         <code>NextToken</code> value that you can use to get another batch of objects.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyId());
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtectionStatusRequest)) {
            return false;
        }
        GetProtectionStatusRequest other = (GetProtectionStatusRequest) obj;
        return Objects.equals(policyId(), other.policyId()) && Objects.equals(memberAccountId(), other.memberAccountId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetProtectionStatusRequest").add("PolicyId", policyId())
                .add("MemberAccountId", memberAccountId()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyId":
            return Optional.ofNullable(clazz.cast(policyId()));
        case "MemberAccountId":
            return Optional.ofNullable(clazz.cast(memberAccountId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtectionStatusRequest, T> g) {
        return obj -> g.apply((GetProtectionStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FmsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetProtectionStatusRequest> {
        /**
         * <p>
         * The ID of the policy for which you want to get the attack information.
         * </p>
         * 
         * @param policyId
         *        The ID of the policy for which you want to get the attack information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyId(String policyId);

        /**
         * <p>
         * The AWS account that is in scope of the policy that you want to get the details for.
         * </p>
         * 
         * @param memberAccountId
         *        The AWS account that is in scope of the policy that you want to get the details for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountId(String memberAccountId);

        /**
         * <p>
         * The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The request
         * syntax listing indicates a <code>number</code> type because the default used by AWS Firewall Manager is Unix
         * time in seconds. However, any valid <code>timestamp</code> format is allowed.
         * </p>
         * 
         * @param startTime
         *        The start of the time period to query for the attacks. This is a <code>timestamp</code> type. The
         *        request syntax listing indicates a <code>number</code> type because the default used by AWS Firewall
         *        Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The request
         * syntax listing indicates a <code>number</code> type because the default used by AWS Firewall Manager is Unix
         * time in seconds. However, any valid <code>timestamp</code> format is allowed.
         * </p>
         * 
         * @param endTime
         *        The end of the time period to query for the attacks. This is a <code>timestamp</code> type. The
         *        request syntax listing indicates a <code>number</code> type because the default used by AWS Firewall
         *        Manager is Unix time in seconds. However, any valid <code>timestamp</code> format is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * If you specify a value for <code>MaxResults</code> and you have more objects than the number that you specify
         * for <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value in the response,
         * which you can use to retrieve another group of objects. For the second and subsequent
         * <code>GetProtectionStatus</code> requests, specify the value of <code>NextToken</code> from the previous
         * response to get information about another batch of objects.
         * </p>
         * 
         * @param nextToken
         *        If you specify a value for <code>MaxResults</code> and you have more objects than the number that you
         *        specify for <code>MaxResults</code>, AWS Firewall Manager returns a <code>NextToken</code> value in
         *        the response, which you can use to retrieve another group of objects. For the second and subsequent
         *        <code>GetProtectionStatus</code> requests, specify the value of <code>NextToken</code> from the
         *        previous response to get information about another batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the number of objects that you want AWS Firewall Manager to return for this request. If you have
         * more objects than the number that you specify for <code>MaxResults</code>, the response includes a
         * <code>NextToken</code> value that you can use to get another batch of objects.
         * </p>
         * 
         * @param maxResults
         *        Specifies the number of objects that you want AWS Firewall Manager to return for this request. If you
         *        have more objects than the number that you specify for <code>MaxResults</code>, the response includes
         *        a <code>NextToken</code> value that you can use to get another batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FmsRequest.BuilderImpl implements Builder {
        private String policyId;

        private String memberAccountId;

        private Instant startTime;

        private Instant endTime;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtectionStatusRequest model) {
            super(model);
            policyId(model.policyId);
            memberAccountId(model.memberAccountId);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getPolicyId() {
            return policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getMemberAccountId() {
            return memberAccountId;
        }

        @Override
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProtectionStatusRequest build() {
            return new GetProtectionStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
