/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.ExperimentAction;
import software.amazon.awssdk.services.fis.model.ExperimentActionMapCopier;
import software.amazon.awssdk.services.fis.model.ExperimentLogConfiguration;
import software.amazon.awssdk.services.fis.model.ExperimentOptions;
import software.amazon.awssdk.services.fis.model.ExperimentReport;
import software.amazon.awssdk.services.fis.model.ExperimentReportConfiguration;
import software.amazon.awssdk.services.fis.model.ExperimentState;
import software.amazon.awssdk.services.fis.model.ExperimentStopCondition;
import software.amazon.awssdk.services.fis.model.ExperimentStopConditionListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentTarget;
import software.amazon.awssdk.services.fis.model.ExperimentTargetMapCopier;
import software.amazon.awssdk.services.fis.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Experiment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Experiment> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Experiment.getter(Experiment::id)).setter(Experiment.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Experiment.getter(Experiment::arn)).setter(Experiment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> EXPERIMENT_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experimentTemplateId").getter(Experiment.getter(Experiment::experimentTemplateId)).setter(Experiment.setter(Builder::experimentTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentTemplateId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(Experiment.getter(Experiment::roleArn)).setter(Experiment.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<ExperimentState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(Experiment.getter(Experiment::state)).setter(Experiment.setter(Builder::state)).constructor(ExperimentState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, ExperimentTarget>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targets").getter(Experiment.getter(Experiment::targets)).setter(Experiment.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ExperimentAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("actions").getter(Experiment.getter(Experiment::actions)).setter(Experiment.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<ExperimentStopCondition>> STOP_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stopConditions").getter(Experiment.getter(Experiment::stopConditions)).setter(Experiment.setter(Builder::stopConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExperimentStopCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Experiment.getter(Experiment::creationTime)).setter(Experiment.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Experiment.getter(Experiment::startTime)).setter(Experiment.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Experiment.getter(Experiment::endTime)).setter(Experiment.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Experiment.getter(Experiment::tags)).setter(Experiment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ExperimentLogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(Experiment.getter(Experiment::logConfiguration)).setter(Experiment.setter(Builder::logConfiguration)).constructor(ExperimentLogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<ExperimentOptions> EXPERIMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("experimentOptions").getter(Experiment.getter(Experiment::experimentOptions)).setter(Experiment.setter(Builder::experimentOptions)).constructor(ExperimentOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentOptions").build()}).build();
    private static final SdkField<Long> TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetAccountConfigurationsCount").getter(Experiment.getter(Experiment::targetAccountConfigurationsCount)).setter(Experiment.setter(Builder::targetAccountConfigurationsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountConfigurationsCount").build()}).build();
    private static final SdkField<ExperimentReportConfiguration> EXPERIMENT_REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("experimentReportConfiguration").getter(Experiment.getter(Experiment::experimentReportConfiguration)).setter(Experiment.setter(Builder::experimentReportConfiguration)).constructor(ExperimentReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentReportConfiguration").build()}).build();
    private static final SdkField<ExperimentReport> EXPERIMENT_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("experimentReport").getter(Experiment.getter(Experiment::experimentReport)).setter(Experiment.setter(Builder::experimentReport)).constructor(ExperimentReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentReport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, EXPERIMENT_TEMPLATE_ID_FIELD, ROLE_ARN_FIELD, STATE_FIELD, TARGETS_FIELD, ACTIONS_FIELD, STOP_CONDITIONS_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, TAGS_FIELD, LOG_CONFIGURATION_FIELD, EXPERIMENT_OPTIONS_FIELD, TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD, EXPERIMENT_REPORT_CONFIGURATION_FIELD, EXPERIMENT_REPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Experiment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String experimentTemplateId;
    private final String roleArn;
    private final ExperimentState state;
    private final Map<String, ExperimentTarget> targets;
    private final Map<String, ExperimentAction> actions;
    private final List<ExperimentStopCondition> stopConditions;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant endTime;
    private final Map<String, String> tags;
    private final ExperimentLogConfiguration logConfiguration;
    private final ExperimentOptions experimentOptions;
    private final Long targetAccountConfigurationsCount;
    private final ExperimentReportConfiguration experimentReportConfiguration;
    private final ExperimentReport experimentReport;

    private Experiment(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.experimentTemplateId = builder.experimentTemplateId;
        this.roleArn = builder.roleArn;
        this.state = builder.state;
        this.targets = builder.targets;
        this.actions = builder.actions;
        this.stopConditions = builder.stopConditions;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.tags = builder.tags;
        this.logConfiguration = builder.logConfiguration;
        this.experimentOptions = builder.experimentOptions;
        this.targetAccountConfigurationsCount = builder.targetAccountConfigurationsCount;
        this.experimentReportConfiguration = builder.experimentReportConfiguration;
        this.experimentReport = builder.experimentReport;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String experimentTemplateId() {
        return this.experimentTemplateId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ExperimentState state() {
        return this.state;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExperimentTarget> targets() {
        return this.targets;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructMap);
    }

    public final Map<String, ExperimentAction> actions() {
        return this.actions;
    }

    public final boolean hasStopConditions() {
        return this.stopConditions != null && !(this.stopConditions instanceof SdkAutoConstructList);
    }

    public final List<ExperimentStopCondition> stopConditions() {
        return this.stopConditions;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ExperimentLogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final ExperimentOptions experimentOptions() {
        return this.experimentOptions;
    }

    public final Long targetAccountConfigurationsCount() {
        return this.targetAccountConfigurationsCount;
    }

    public final ExperimentReportConfiguration experimentReportConfiguration() {
        return this.experimentReportConfiguration;
    }

    public final ExperimentReport experimentReport() {
        return this.experimentReport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStopConditions() ? this.stopConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAccountConfigurationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentReportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentReport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        Experiment other = (Experiment)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.experimentTemplateId(), other.experimentTemplateId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.state(), other.state()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasStopConditions() == other.hasStopConditions() && Objects.equals(this.stopConditions(), other.stopConditions()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.experimentOptions(), other.experimentOptions()) && Objects.equals(this.targetAccountConfigurationsCount(), other.targetAccountConfigurationsCount()) && Objects.equals(this.experimentReportConfiguration(), other.experimentReportConfiguration()) && Objects.equals(this.experimentReport(), other.experimentReport());
    }

    public final String toString() {
        return ToString.builder((String)"Experiment").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ExperimentTemplateId", (Object)this.experimentTemplateId()).add("RoleArn", (Object)this.roleArn()).add("State", (Object)this.state()).add("Targets", this.hasTargets() ? this.targets() : null).add("Actions", this.hasActions() ? this.actions() : null).add("StopConditions", this.hasStopConditions() ? this.stopConditions() : null).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Tags", this.hasTags() ? this.tags() : null).add("LogConfiguration", (Object)this.logConfiguration()).add("ExperimentOptions", (Object)this.experimentOptions()).add("TargetAccountConfigurationsCount", (Object)this.targetAccountConfigurationsCount()).add("ExperimentReportConfiguration", (Object)this.experimentReportConfiguration()).add("ExperimentReport", (Object)this.experimentReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "experimentTemplateId": {
                return Optional.ofNullable(clazz.cast(this.experimentTemplateId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "stopConditions": {
                return Optional.ofNullable(clazz.cast(this.stopConditions()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "experimentOptions": {
                return Optional.ofNullable(clazz.cast(this.experimentOptions()));
            }
            case "targetAccountConfigurationsCount": {
                return Optional.ofNullable(clazz.cast(this.targetAccountConfigurationsCount()));
            }
            case "experimentReportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.experimentReportConfiguration()));
            }
            case "experimentReport": {
                return Optional.ofNullable(clazz.cast(this.experimentReport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("experimentTemplateId", EXPERIMENT_TEMPLATE_ID_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("targets", TARGETS_FIELD);
        map.put("actions", ACTIONS_FIELD);
        map.put("stopConditions", STOP_CONDITIONS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("logConfiguration", LOG_CONFIGURATION_FIELD);
        map.put("experimentOptions", EXPERIMENT_OPTIONS_FIELD);
        map.put("targetAccountConfigurationsCount", TARGET_ACCOUNT_CONFIGURATIONS_COUNT_FIELD);
        map.put("experimentReportConfiguration", EXPERIMENT_REPORT_CONFIGURATION_FIELD);
        map.put("experimentReport", EXPERIMENT_REPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Experiment, T> g) {
        return obj -> g.apply((Experiment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String experimentTemplateId;
        private String roleArn;
        private ExperimentState state;
        private Map<String, ExperimentTarget> targets = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ExperimentAction> actions = DefaultSdkAutoConstructMap.getInstance();
        private List<ExperimentStopCondition> stopConditions = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant startTime;
        private Instant endTime;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ExperimentLogConfiguration logConfiguration;
        private ExperimentOptions experimentOptions;
        private Long targetAccountConfigurationsCount;
        private ExperimentReportConfiguration experimentReportConfiguration;
        private ExperimentReport experimentReport;

        private BuilderImpl() {
        }

        private BuilderImpl(Experiment model) {
            this.id(model.id);
            this.arn(model.arn);
            this.experimentTemplateId(model.experimentTemplateId);
            this.roleArn(model.roleArn);
            this.state(model.state);
            this.targets(model.targets);
            this.actions(model.actions);
            this.stopConditions(model.stopConditions);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.tags(model.tags);
            this.logConfiguration(model.logConfiguration);
            this.experimentOptions(model.experimentOptions);
            this.targetAccountConfigurationsCount(model.targetAccountConfigurationsCount);
            this.experimentReportConfiguration(model.experimentReportConfiguration);
            this.experimentReport(model.experimentReport);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getExperimentTemplateId() {
            return this.experimentTemplateId;
        }

        public final void setExperimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
        }

        @Override
        public final Builder experimentTemplateId(String experimentTemplateId) {
            this.experimentTemplateId = experimentTemplateId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ExperimentState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ExperimentState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ExperimentState state) {
            this.state = state;
            return this;
        }

        public final Map<String, ExperimentTarget.Builder> getTargets() {
            Map<String, ExperimentTarget.Builder> result = ExperimentTargetMapCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTargets(Map<String, ExperimentTarget.BuilderImpl> targets) {
            this.targets = ExperimentTargetMapCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Map<String, ExperimentTarget> targets) {
            this.targets = ExperimentTargetMapCopier.copy(targets);
            return this;
        }

        public final Map<String, ExperimentAction.Builder> getActions() {
            Map<String, ExperimentAction.Builder> result = ExperimentActionMapCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setActions(Map<String, ExperimentAction.BuilderImpl> actions) {
            this.actions = ExperimentActionMapCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Map<String, ExperimentAction> actions) {
            this.actions = ExperimentActionMapCopier.copy(actions);
            return this;
        }

        public final List<ExperimentStopCondition.Builder> getStopConditions() {
            List<ExperimentStopCondition.Builder> result = ExperimentStopConditionListCopier.copyToBuilder(this.stopConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStopConditions(Collection<ExperimentStopCondition.BuilderImpl> stopConditions) {
            this.stopConditions = ExperimentStopConditionListCopier.copyFromBuilder(stopConditions);
        }

        @Override
        public final Builder stopConditions(Collection<ExperimentStopCondition> stopConditions) {
            this.stopConditions = ExperimentStopConditionListCopier.copy(stopConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(ExperimentStopCondition ... stopConditions) {
            this.stopConditions(Arrays.asList(stopConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stopConditions(Consumer<ExperimentStopCondition.Builder> ... stopConditions) {
            this.stopConditions(Stream.of(stopConditions).map(c -> (ExperimentStopCondition)((ExperimentStopCondition.Builder)ExperimentStopCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ExperimentLogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(ExperimentLogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(ExperimentLogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final ExperimentOptions.Builder getExperimentOptions() {
            return this.experimentOptions != null ? this.experimentOptions.toBuilder() : null;
        }

        public final void setExperimentOptions(ExperimentOptions.BuilderImpl experimentOptions) {
            this.experimentOptions = experimentOptions != null ? experimentOptions.build() : null;
        }

        @Override
        public final Builder experimentOptions(ExperimentOptions experimentOptions) {
            this.experimentOptions = experimentOptions;
            return this;
        }

        public final Long getTargetAccountConfigurationsCount() {
            return this.targetAccountConfigurationsCount;
        }

        public final void setTargetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
            this.targetAccountConfigurationsCount = targetAccountConfigurationsCount;
        }

        @Override
        public final Builder targetAccountConfigurationsCount(Long targetAccountConfigurationsCount) {
            this.targetAccountConfigurationsCount = targetAccountConfigurationsCount;
            return this;
        }

        public final ExperimentReportConfiguration.Builder getExperimentReportConfiguration() {
            return this.experimentReportConfiguration != null ? this.experimentReportConfiguration.toBuilder() : null;
        }

        public final void setExperimentReportConfiguration(ExperimentReportConfiguration.BuilderImpl experimentReportConfiguration) {
            this.experimentReportConfiguration = experimentReportConfiguration != null ? experimentReportConfiguration.build() : null;
        }

        @Override
        public final Builder experimentReportConfiguration(ExperimentReportConfiguration experimentReportConfiguration) {
            this.experimentReportConfiguration = experimentReportConfiguration;
            return this;
        }

        public final ExperimentReport.Builder getExperimentReport() {
            return this.experimentReport != null ? this.experimentReport.toBuilder() : null;
        }

        public final void setExperimentReport(ExperimentReport.BuilderImpl experimentReport) {
            this.experimentReport = experimentReport != null ? experimentReport.build() : null;
        }

        @Override
        public final Builder experimentReport(ExperimentReport experimentReport) {
            this.experimentReport = experimentReport;
            return this;
        }

        public Experiment build() {
            return new Experiment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Experiment> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder experimentTemplateId(String var1);

        public Builder roleArn(String var1);

        public Builder state(ExperimentState var1);

        default public Builder state(Consumer<ExperimentState.Builder> state) {
            return this.state((ExperimentState)((ExperimentState.Builder)ExperimentState.builder().applyMutation(state)).build());
        }

        public Builder targets(Map<String, ExperimentTarget> var1);

        public Builder actions(Map<String, ExperimentAction> var1);

        public Builder stopConditions(Collection<ExperimentStopCondition> var1);

        public Builder stopConditions(ExperimentStopCondition ... var1);

        public Builder stopConditions(Consumer<ExperimentStopCondition.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder tags(Map<String, String> var1);

        public Builder logConfiguration(ExperimentLogConfiguration var1);

        default public Builder logConfiguration(Consumer<ExperimentLogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((ExperimentLogConfiguration)((ExperimentLogConfiguration.Builder)ExperimentLogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder experimentOptions(ExperimentOptions var1);

        default public Builder experimentOptions(Consumer<ExperimentOptions.Builder> experimentOptions) {
            return this.experimentOptions((ExperimentOptions)((ExperimentOptions.Builder)ExperimentOptions.builder().applyMutation(experimentOptions)).build());
        }

        public Builder targetAccountConfigurationsCount(Long var1);

        public Builder experimentReportConfiguration(ExperimentReportConfiguration var1);

        default public Builder experimentReportConfiguration(Consumer<ExperimentReportConfiguration.Builder> experimentReportConfiguration) {
            return this.experimentReportConfiguration((ExperimentReportConfiguration)((ExperimentReportConfiguration.Builder)ExperimentReportConfiguration.builder().applyMutation(experimentReportConfiguration)).build());
        }

        public Builder experimentReport(ExperimentReport var1);

        default public Builder experimentReport(Consumer<ExperimentReport.Builder> experimentReport) {
            return this.experimentReport((ExperimentReport)((ExperimentReport.Builder)ExperimentReport.builder().applyMutation(experimentReport)).build());
        }
    }
}

