/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.TargetInformationMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolvedTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolvedTarget> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ResolvedTarget.getter(ResolvedTarget::resourceType)).setter(ResolvedTarget.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetName").getter(ResolvedTarget.getter(ResolvedTarget::targetName)).setter(ResolvedTarget.setter(Builder::targetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()}).build();
    private static final SdkField<Map<String, String>> TARGET_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targetInformation").getter(ResolvedTarget.getter(ResolvedTarget::targetInformation)).setter(ResolvedTarget.setter(Builder::targetInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInformation").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, TARGET_NAME_FIELD, TARGET_INFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String targetName;
    private final Map<String, String> targetInformation;

    private ResolvedTarget(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.targetName = builder.targetName;
        this.targetInformation = builder.targetInformation;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String targetName() {
        return this.targetName;
    }

    public final boolean hasTargetInformation() {
        return this.targetInformation != null && !(this.targetInformation instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> targetInformation() {
        return this.targetInformation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetInformation() ? this.targetInformation() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedTarget)) {
            return false;
        }
        ResolvedTarget other = (ResolvedTarget)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.targetName(), other.targetName()) && this.hasTargetInformation() == other.hasTargetInformation() && Objects.equals(this.targetInformation(), other.targetInformation());
    }

    public final String toString() {
        return ToString.builder((String)"ResolvedTarget").add("ResourceType", (Object)this.resourceType()).add("TargetName", (Object)this.targetName()).add("TargetInformation", this.hasTargetInformation() ? this.targetInformation() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "targetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
            case "targetInformation": {
                return Optional.ofNullable(clazz.cast(this.targetInformation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolvedTarget, T> g) {
        return obj -> g.apply((ResolvedTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String targetName;
        private Map<String, String> targetInformation = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedTarget model) {
            this.resourceType(model.resourceType);
            this.targetName(model.targetName);
            this.targetInformation(model.targetInformation);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final Map<String, String> getTargetInformation() {
            if (this.targetInformation instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.targetInformation;
        }

        public final void setTargetInformation(Map<String, String> targetInformation) {
            this.targetInformation = TargetInformationMapCopier.copy(targetInformation);
        }

        @Override
        public final Builder targetInformation(Map<String, String> targetInformation) {
            this.targetInformation = TargetInformationMapCopier.copy(targetInformation);
            return this;
        }

        public ResolvedTarget build() {
            return new ResolvedTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolvedTarget> {
        public Builder resourceType(String var1);

        public Builder targetName(String var1);

        public Builder targetInformation(Map<String, String> var1);
    }
}

