/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.fis.FisAsyncClient;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesRequest;
import software.amazon.awssdk.services.fis.model.ListExperimentTemplatesResponse;

public class ListExperimentTemplatesPublisher
implements SdkPublisher<ListExperimentTemplatesResponse> {
    private final FisAsyncClient client;
    private final ListExperimentTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExperimentTemplatesPublisher(FisAsyncClient client, ListExperimentTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExperimentTemplatesPublisher(FisAsyncClient client, ListExperimentTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExperimentTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExperimentTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExperimentTemplatesResponseFetcher
    implements AsyncPageFetcher<ListExperimentTemplatesResponse> {
        private ListExperimentTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListExperimentTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExperimentTemplatesResponse> nextPage(ListExperimentTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListExperimentTemplatesPublisher.this.client.listExperimentTemplates(ListExperimentTemplatesPublisher.this.firstRequest);
            }
            return ListExperimentTemplatesPublisher.this.client.listExperimentTemplates((ListExperimentTemplatesRequest)((Object)ListExperimentTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

