/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fis.model.ExperimentActionParameterMapCopier;
import software.amazon.awssdk.services.fis.model.ExperimentActionStartAfterListCopier;
import software.amazon.awssdk.services.fis.model.ExperimentActionState;
import software.amazon.awssdk.services.fis.model.ExperimentActionTargetMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentAction> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionId").getter(ExperimentAction.getter(ExperimentAction::actionId)).setter(ExperimentAction.setter(Builder::actionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ExperimentAction.getter(ExperimentAction::description)).setter(ExperimentAction.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(ExperimentAction.getter(ExperimentAction::parameters)).setter(ExperimentAction.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("targets").getter(ExperimentAction.getter(ExperimentAction::targets)).setter(ExperimentAction.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> START_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("startAfter").getter(ExperimentAction.getter(ExperimentAction::startAfter)).setter(ExperimentAction.setter(Builder::startAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startAfter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExperimentActionState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(ExperimentAction.getter(ExperimentAction::state)).setter(ExperimentAction.setter(Builder::state)).constructor(ExperimentActionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(ExperimentAction.getter(ExperimentAction::startTime)).setter(ExperimentAction.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ExperimentAction.getter(ExperimentAction::endTime)).setter(ExperimentAction.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, TARGETS_FIELD, START_AFTER_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionId;
    private final String description;
    private final Map<String, String> parameters;
    private final Map<String, String> targets;
    private final List<String> startAfter;
    private final ExperimentActionState state;
    private final Instant startTime;
    private final Instant endTime;

    private ExperimentAction(BuilderImpl builder) {
        this.actionId = builder.actionId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.targets = builder.targets;
        this.startAfter = builder.startAfter;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String actionId() {
        return this.actionId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> targets() {
        return this.targets;
    }

    public final boolean hasStartAfter() {
        return this.startAfter != null && !(this.startAfter instanceof SdkAutoConstructList);
    }

    public final List<String> startAfter() {
        return this.startAfter;
    }

    public final ExperimentActionState state() {
        return this.state;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartAfter() ? this.startAfter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentAction)) {
            return false;
        }
        ExperimentAction other = (ExperimentAction)obj;
        return Objects.equals(this.actionId(), other.actionId()) && Objects.equals(this.description(), other.description()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && this.hasStartAfter() == other.hasStartAfter() && Objects.equals(this.startAfter(), other.startAfter()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentAction").add("ActionId", (Object)this.actionId()).add("Description", (Object)this.description()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Targets", this.hasTargets() ? this.targets() : null).add("StartAfter", this.hasStartAfter() ? this.startAfter() : null).add("State", (Object)this.state()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionId": {
                return Optional.ofNullable(clazz.cast(this.actionId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "startAfter": {
                return Optional.ofNullable(clazz.cast(this.startAfter()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentAction, T> g) {
        return obj -> g.apply((ExperimentAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionId;
        private String description;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> targets = DefaultSdkAutoConstructMap.getInstance();
        private List<String> startAfter = DefaultSdkAutoConstructList.getInstance();
        private ExperimentActionState state;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentAction model) {
            this.actionId(model.actionId);
            this.description(model.description);
            this.parameters(model.parameters);
            this.targets(model.targets);
            this.startAfter(model.startAfter);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getActionId() {
            return this.actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ExperimentActionParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ExperimentActionParameterMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, String> getTargets() {
            if (this.targets instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Map<String, String> targets) {
            this.targets = ExperimentActionTargetMapCopier.copy(targets);
        }

        @Override
        public final Builder targets(Map<String, String> targets) {
            this.targets = ExperimentActionTargetMapCopier.copy(targets);
            return this;
        }

        public final Collection<String> getStartAfter() {
            if (this.startAfter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.startAfter;
        }

        public final void setStartAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentActionStartAfterListCopier.copy(startAfter);
        }

        @Override
        public final Builder startAfter(Collection<String> startAfter) {
            this.startAfter = ExperimentActionStartAfterListCopier.copy(startAfter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startAfter(String ... startAfter) {
            this.startAfter(Arrays.asList(startAfter));
            return this;
        }

        public final ExperimentActionState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ExperimentActionState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ExperimentActionState state) {
            this.state = state;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public ExperimentAction build() {
            return new ExperimentAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentAction> {
        public Builder actionId(String var1);

        public Builder description(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder targets(Map<String, String> var1);

        public Builder startAfter(Collection<String> var1);

        public Builder startAfter(String ... var1);

        public Builder state(ExperimentActionState var1);

        default public Builder state(Consumer<ExperimentActionState.Builder> state) {
            return this.state((ExperimentActionState)((ExperimentActionState.Builder)ExperimentActionState.builder().applyMutation(state)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

