/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamNameListCopier;
import software.amazon.awssdk.services.firehose.model.FirehoseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeliveryStreamsResponse
extends FirehoseResponse
implements ToCopyableBuilder<Builder, ListDeliveryStreamsResponse> {
    private static final SdkField<List<String>> DELIVERY_STREAM_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDeliveryStreamsResponse.getter(ListDeliveryStreamsResponse::deliveryStreamNames)).setter(ListDeliveryStreamsResponse.setter(Builder::deliveryStreamNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> HAS_MORE_DELIVERY_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListDeliveryStreamsResponse.getter(ListDeliveryStreamsResponse::hasMoreDeliveryStreams)).setter(ListDeliveryStreamsResponse.setter(Builder::hasMoreDeliveryStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreDeliveryStreams").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAMES_FIELD, HAS_MORE_DELIVERY_STREAMS_FIELD));
    private final List<String> deliveryStreamNames;
    private final Boolean hasMoreDeliveryStreams;

    private ListDeliveryStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamNames = builder.deliveryStreamNames;
        this.hasMoreDeliveryStreams = builder.hasMoreDeliveryStreams;
    }

    public List<String> deliveryStreamNames() {
        return this.deliveryStreamNames;
    }

    public Boolean hasMoreDeliveryStreams() {
        return this.hasMoreDeliveryStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMoreDeliveryStreams());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliveryStreamsResponse)) {
            return false;
        }
        ListDeliveryStreamsResponse other = (ListDeliveryStreamsResponse)((Object)obj);
        return Objects.equals(this.deliveryStreamNames(), other.deliveryStreamNames()) && Objects.equals(this.hasMoreDeliveryStreams(), other.hasMoreDeliveryStreams());
    }

    public String toString() {
        return ToString.builder((String)"ListDeliveryStreamsResponse").add("DeliveryStreamNames", this.deliveryStreamNames()).add("HasMoreDeliveryStreams", (Object)this.hasMoreDeliveryStreams()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamNames": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamNames()));
            }
            case "HasMoreDeliveryStreams": {
                return Optional.ofNullable(clazz.cast(this.hasMoreDeliveryStreams()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeliveryStreamsResponse, T> g) {
        return obj -> g.apply((ListDeliveryStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseResponse.BuilderImpl
    implements Builder {
        private List<String> deliveryStreamNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean hasMoreDeliveryStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliveryStreamsResponse model) {
            super(model);
            this.deliveryStreamNames(model.deliveryStreamNames);
            this.hasMoreDeliveryStreams(model.hasMoreDeliveryStreams);
        }

        public final Collection<String> getDeliveryStreamNames() {
            return this.deliveryStreamNames;
        }

        @Override
        public final Builder deliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryStreamNames(String ... deliveryStreamNames) {
            this.deliveryStreamNames(Arrays.asList(deliveryStreamNames));
            return this;
        }

        public final void setDeliveryStreamNames(Collection<String> deliveryStreamNames) {
            this.deliveryStreamNames = DeliveryStreamNameListCopier.copy(deliveryStreamNames);
        }

        public final Boolean getHasMoreDeliveryStreams() {
            return this.hasMoreDeliveryStreams;
        }

        @Override
        public final Builder hasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
            return this;
        }

        public final void setHasMoreDeliveryStreams(Boolean hasMoreDeliveryStreams) {
            this.hasMoreDeliveryStreams = hasMoreDeliveryStreams;
        }

        @Override
        public ListDeliveryStreamsResponse build() {
            return new ListDeliveryStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeliveryStreamsResponse> {
        public Builder deliveryStreamNames(Collection<String> var1);

        public Builder deliveryStreamNames(String ... var1);

        public Builder hasMoreDeliveryStreams(Boolean var1);
    }
}

