/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CompressionFormat {
    UNCOMPRESSED("UNCOMPRESSED"),
    GZIP("GZIP"),
    ZIP("ZIP"),
    SNAPPY("Snappy"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CompressionFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompressionFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CompressionFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompressionFormat> knownValues() {
        return Stream.of(CompressionFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

