/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.Processor;
import software.amazon.awssdk.services.firehose.model.ProcessorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProcessingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProcessingConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ProcessingConfiguration.getter(ProcessingConfiguration::enabled)).setter(ProcessingConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<Processor>> PROCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProcessingConfiguration.getter(ProcessingConfiguration::processors)).setter(ProcessingConfiguration.setter(Builder::processors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Processor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, PROCESSORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final List<Processor> processors;

    private ProcessingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.processors = builder.processors;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<Processor> processors() {
        return this.processors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.processors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingConfiguration)) {
            return false;
        }
        ProcessingConfiguration other = (ProcessingConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.processors(), other.processors());
    }

    public String toString() {
        return ToString.builder((String)"ProcessingConfiguration").add("Enabled", (Object)this.enabled()).add("Processors", this.processors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Processors": {
                return Optional.ofNullable(clazz.cast(this.processors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingConfiguration, T> g) {
        return obj -> g.apply((ProcessingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<Processor> processors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingConfiguration model) {
            this.enabled(model.enabled);
            this.processors(model.processors);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Processor.Builder> getProcessors() {
            return this.processors != null ? (Collection)this.processors.stream().map(Processor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor ... processors) {
            this.processors(Arrays.asList(processors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Consumer<Processor.Builder> ... processors) {
            this.processors(Stream.of(processors).map(c -> (Processor)((Processor.Builder)Processor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessors(Collection<Processor.BuilderImpl> processors) {
            this.processors = ProcessorListCopier.copyFromBuilder(processors);
        }

        public ProcessingConfiguration build() {
            return new ProcessingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProcessingConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder processors(Collection<Processor> var1);

        public Builder processors(Processor ... var1);

        public Builder processors(Consumer<Processor.Builder> ... var1);
    }
}

