/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CompressionFormat;
import software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration;
import software.amazon.awssdk.services.firehose.model.DynamicPartitioningConfiguration;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtendedS3DestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtendedS3DestinationConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::roleARN)).setter(ExtendedS3DestinationConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARN").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::bucketARN)).setter(ExtendedS3DestinationConfiguration.setter(Builder::bucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::prefix)).setter(ExtendedS3DestinationConfiguration.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> ERROR_OUTPUT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorOutputPrefix").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::errorOutputPrefix)).setter(ExtendedS3DestinationConfiguration.setter(Builder::errorOutputPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorOutputPrefix").build()}).build();
    private static final SdkField<BufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::bufferingHints)).setter(ExtendedS3DestinationConfiguration.setter(Builder::bufferingHints)).constructor(BufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<String> COMPRESSION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionFormat").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::compressionFormatAsString)).setter(ExtendedS3DestinationConfiguration.setter(Builder::compressionFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionFormat").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::encryptionConfiguration)).setter(ExtendedS3DestinationConfiguration.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::cloudWatchLoggingOptions)).setter(ExtendedS3DestinationConfiguration.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::processingConfiguration)).setter(ExtendedS3DestinationConfiguration.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::s3BackupModeAsString)).setter(ExtendedS3DestinationConfiguration.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_BACKUP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3BackupConfiguration").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::s3BackupConfiguration)).setter(ExtendedS3DestinationConfiguration.setter(Builder::s3BackupConfiguration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupConfiguration").build()}).build();
    private static final SdkField<DataFormatConversionConfiguration> DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataFormatConversionConfiguration").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::dataFormatConversionConfiguration)).setter(ExtendedS3DestinationConfiguration.setter(Builder::dataFormatConversionConfiguration)).constructor(DataFormatConversionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormatConversionConfiguration").build()}).build();
    private static final SdkField<DynamicPartitioningConfiguration> DYNAMIC_PARTITIONING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamicPartitioningConfiguration").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::dynamicPartitioningConfiguration)).setter(ExtendedS3DestinationConfiguration.setter(Builder::dynamicPartitioningConfiguration)).constructor(DynamicPartitioningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicPartitioningConfiguration").build()}).build();
    private static final SdkField<String> FILE_EXTENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileExtension").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::fileExtension)).setter(ExtendedS3DestinationConfiguration.setter(Builder::fileExtension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileExtension").build()}).build();
    private static final SdkField<String> CUSTOM_TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomTimeZone").getter(ExtendedS3DestinationConfiguration.getter(ExtendedS3DestinationConfiguration::customTimeZone)).setter(ExtendedS3DestinationConfiguration.setter(Builder::customTimeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomTimeZone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, BUCKET_ARN_FIELD, PREFIX_FIELD, ERROR_OUTPUT_PREFIX_FIELD, BUFFERING_HINTS_FIELD, COMPRESSION_FORMAT_FIELD, ENCRYPTION_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, S3_BACKUP_MODE_FIELD, S3_BACKUP_CONFIGURATION_FIELD, DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD, DYNAMIC_PARTITIONING_CONFIGURATION_FIELD, FILE_EXTENSION_FIELD, CUSTOM_TIME_ZONE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExtendedS3DestinationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String bucketARN;
    private final String prefix;
    private final String errorOutputPrefix;
    private final BufferingHints bufferingHints;
    private final String compressionFormat;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationConfiguration s3BackupConfiguration;
    private final DataFormatConversionConfiguration dataFormatConversionConfiguration;
    private final DynamicPartitioningConfiguration dynamicPartitioningConfiguration;
    private final String fileExtension;
    private final String customTimeZone;

    private ExtendedS3DestinationConfiguration(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.errorOutputPrefix = builder.errorOutputPrefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupConfiguration = builder.s3BackupConfiguration;
        this.dataFormatConversionConfiguration = builder.dataFormatConversionConfiguration;
        this.dynamicPartitioningConfiguration = builder.dynamicPartitioningConfiguration;
        this.fileExtension = builder.fileExtension;
        this.customTimeZone = builder.customTimeZone;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String bucketARN() {
        return this.bucketARN;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String errorOutputPrefix() {
        return this.errorOutputPrefix;
    }

    public final BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(this.compressionFormat);
    }

    public final String compressionFormatAsString() {
        return this.compressionFormat;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final S3BackupMode s3BackupMode() {
        return S3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationConfiguration s3BackupConfiguration() {
        return this.s3BackupConfiguration;
    }

    public final DataFormatConversionConfiguration dataFormatConversionConfiguration() {
        return this.dataFormatConversionConfiguration;
    }

    public final DynamicPartitioningConfiguration dynamicPartitioningConfiguration() {
        return this.dynamicPartitioningConfiguration;
    }

    public final String fileExtension() {
        return this.fileExtension;
    }

    public final String customTimeZone() {
        return this.customTimeZone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorOutputPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatConversionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicPartitioningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileExtension());
        hashCode = 31 * hashCode + Objects.hashCode(this.customTimeZone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedS3DestinationConfiguration)) {
            return false;
        }
        ExtendedS3DestinationConfiguration other = (ExtendedS3DestinationConfiguration)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.errorOutputPrefix(), other.errorOutputPrefix()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.compressionFormatAsString(), other.compressionFormatAsString()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3BackupConfiguration(), other.s3BackupConfiguration()) && Objects.equals(this.dataFormatConversionConfiguration(), other.dataFormatConversionConfiguration()) && Objects.equals(this.dynamicPartitioningConfiguration(), other.dynamicPartitioningConfiguration()) && Objects.equals(this.fileExtension(), other.fileExtension()) && Objects.equals(this.customTimeZone(), other.customTimeZone());
    }

    public final String toString() {
        return ToString.builder((String)"ExtendedS3DestinationConfiguration").add("RoleARN", (Object)this.roleARN()).add("BucketARN", (Object)this.bucketARN()).add("Prefix", (Object)this.prefix()).add("ErrorOutputPrefix", (Object)this.errorOutputPrefix()).add("BufferingHints", (Object)this.bufferingHints()).add("CompressionFormat", (Object)this.compressionFormatAsString()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3BackupConfiguration", (Object)this.s3BackupConfiguration()).add("DataFormatConversionConfiguration", (Object)this.dataFormatConversionConfiguration()).add("DynamicPartitioningConfiguration", (Object)this.dynamicPartitioningConfiguration()).add("FileExtension", (Object)this.fileExtension()).add("CustomTimeZone", (Object)this.customTimeZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "BucketARN": {
                return Optional.ofNullable(clazz.cast(this.bucketARN()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "ErrorOutputPrefix": {
                return Optional.ofNullable(clazz.cast(this.errorOutputPrefix()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "CompressionFormat": {
                return Optional.ofNullable(clazz.cast(this.compressionFormatAsString()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3BackupConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3BackupConfiguration()));
            }
            case "DataFormatConversionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataFormatConversionConfiguration()));
            }
            case "DynamicPartitioningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dynamicPartitioningConfiguration()));
            }
            case "FileExtension": {
                return Optional.ofNullable(clazz.cast(this.fileExtension()));
            }
            case "CustomTimeZone": {
                return Optional.ofNullable(clazz.cast(this.customTimeZone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("BucketARN", BUCKET_ARN_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("ErrorOutputPrefix", ERROR_OUTPUT_PREFIX_FIELD);
        map.put("BufferingHints", BUFFERING_HINTS_FIELD);
        map.put("CompressionFormat", COMPRESSION_FORMAT_FIELD);
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("CloudWatchLoggingOptions", CLOUD_WATCH_LOGGING_OPTIONS_FIELD);
        map.put("ProcessingConfiguration", PROCESSING_CONFIGURATION_FIELD);
        map.put("S3BackupMode", S3_BACKUP_MODE_FIELD);
        map.put("S3BackupConfiguration", S3_BACKUP_CONFIGURATION_FIELD);
        map.put("DataFormatConversionConfiguration", DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD);
        map.put("DynamicPartitioningConfiguration", DYNAMIC_PARTITIONING_CONFIGURATION_FIELD);
        map.put("FileExtension", FILE_EXTENSION_FIELD);
        map.put("CustomTimeZone", CUSTOM_TIME_ZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExtendedS3DestinationConfiguration, T> g) {
        return obj -> g.apply((ExtendedS3DestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String bucketARN;
        private String prefix;
        private String errorOutputPrefix;
        private BufferingHints bufferingHints;
        private String compressionFormat;
        private EncryptionConfiguration encryptionConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationConfiguration s3BackupConfiguration;
        private DataFormatConversionConfiguration dataFormatConversionConfiguration;
        private DynamicPartitioningConfiguration dynamicPartitioningConfiguration;
        private String fileExtension;
        private String customTimeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedS3DestinationConfiguration model) {
            this.roleARN(model.roleARN);
            this.bucketARN(model.bucketARN);
            this.prefix(model.prefix);
            this.errorOutputPrefix(model.errorOutputPrefix);
            this.bufferingHints(model.bufferingHints);
            this.compressionFormat(model.compressionFormat);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.s3BackupConfiguration(model.s3BackupConfiguration);
            this.dataFormatConversionConfiguration(model.dataFormatConversionConfiguration);
            this.dynamicPartitioningConfiguration(model.dynamicPartitioningConfiguration);
            this.fileExtension(model.fileExtension);
            this.customTimeZone(model.customTimeZone);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getErrorOutputPrefix() {
            return this.errorOutputPrefix;
        }

        public final void setErrorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
        }

        @Override
        public final Builder errorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat == null ? null : compressionFormat.toString());
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3BackupConfiguration() {
            return this.s3BackupConfiguration != null ? this.s3BackupConfiguration.toBuilder() : null;
        }

        public final void setS3BackupConfiguration(S3DestinationConfiguration.BuilderImpl s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration != null ? s3BackupConfiguration.build() : null;
        }

        @Override
        public final Builder s3BackupConfiguration(S3DestinationConfiguration s3BackupConfiguration) {
            this.s3BackupConfiguration = s3BackupConfiguration;
            return this;
        }

        public final DataFormatConversionConfiguration.Builder getDataFormatConversionConfiguration() {
            return this.dataFormatConversionConfiguration != null ? this.dataFormatConversionConfiguration.toBuilder() : null;
        }

        public final void setDataFormatConversionConfiguration(DataFormatConversionConfiguration.BuilderImpl dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration != null ? dataFormatConversionConfiguration.build() : null;
        }

        @Override
        public final Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
            return this;
        }

        public final DynamicPartitioningConfiguration.Builder getDynamicPartitioningConfiguration() {
            return this.dynamicPartitioningConfiguration != null ? this.dynamicPartitioningConfiguration.toBuilder() : null;
        }

        public final void setDynamicPartitioningConfiguration(DynamicPartitioningConfiguration.BuilderImpl dynamicPartitioningConfiguration) {
            this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration != null ? dynamicPartitioningConfiguration.build() : null;
        }

        @Override
        public final Builder dynamicPartitioningConfiguration(DynamicPartitioningConfiguration dynamicPartitioningConfiguration) {
            this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration;
            return this;
        }

        public final String getFileExtension() {
            return this.fileExtension;
        }

        public final void setFileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
        }

        @Override
        public final Builder fileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
            return this;
        }

        public final String getCustomTimeZone() {
            return this.customTimeZone;
        }

        public final void setCustomTimeZone(String customTimeZone) {
            this.customTimeZone = customTimeZone;
        }

        @Override
        public final Builder customTimeZone(String customTimeZone) {
            this.customTimeZone = customTimeZone;
            return this;
        }

        public ExtendedS3DestinationConfiguration build() {
            return new ExtendedS3DestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtendedS3DestinationConfiguration> {
        public Builder roleARN(String var1);

        public Builder bucketARN(String var1);

        public Builder prefix(String var1);

        public Builder errorOutputPrefix(String var1);

        public Builder bufferingHints(BufferingHints var1);

        default public Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((BufferingHints)((BufferingHints.Builder)BufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(S3BackupMode var1);

        public Builder s3BackupConfiguration(S3DestinationConfiguration var1);

        default public Builder s3BackupConfiguration(Consumer<S3DestinationConfiguration.Builder> s3BackupConfiguration) {
            return this.s3BackupConfiguration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3BackupConfiguration)).build());
        }

        public Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration var1);

        default public Builder dataFormatConversionConfiguration(Consumer<DataFormatConversionConfiguration.Builder> dataFormatConversionConfiguration) {
            return this.dataFormatConversionConfiguration((DataFormatConversionConfiguration)((DataFormatConversionConfiguration.Builder)DataFormatConversionConfiguration.builder().applyMutation(dataFormatConversionConfiguration)).build());
        }

        public Builder dynamicPartitioningConfiguration(DynamicPartitioningConfiguration var1);

        default public Builder dynamicPartitioningConfiguration(Consumer<DynamicPartitioningConfiguration.Builder> dynamicPartitioningConfiguration) {
            return this.dynamicPartitioningConfiguration((DynamicPartitioningConfiguration)((DynamicPartitioningConfiguration.Builder)DynamicPartitioningConfiguration.builder().applyMutation(dynamicPartitioningConfiguration)).build());
        }

        public Builder fileExtension(String var1);

        public Builder customTimeZone(String var1);
    }
}

