/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CatalogConfiguration;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.DestinationTableConfiguration;
import software.amazon.awssdk.services.firehose.model.DestinationTableConfigurationListCopier;
import software.amazon.awssdk.services.firehose.model.IcebergS3BackupMode;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.RetryOptions;
import software.amazon.awssdk.services.firehose.model.S3DestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergDestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergDestinationConfiguration> {
    private static final SdkField<List<DestinationTableConfiguration>> DESTINATION_TABLE_CONFIGURATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationTableConfigurationList").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::destinationTableConfigurationList)).setter(IcebergDestinationConfiguration.setter(Builder::destinationTableConfigurationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableConfigurationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationTableConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::bufferingHints)).setter(IcebergDestinationConfiguration.setter(Builder::bufferingHints)).constructor(BufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::cloudWatchLoggingOptions)).setter(IcebergDestinationConfiguration.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::processingConfiguration)).setter(IcebergDestinationConfiguration.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::s3BackupModeAsString)).setter(IcebergDestinationConfiguration.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<RetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryOptions").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::retryOptions)).setter(IcebergDestinationConfiguration.setter(Builder::retryOptions)).constructor(RetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::roleARN)).setter(IcebergDestinationConfiguration.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<CatalogConfiguration> CATALOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CatalogConfiguration").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::catalogConfiguration)).setter(IcebergDestinationConfiguration.setter(Builder::catalogConfiguration)).constructor(CatalogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogConfiguration").build()}).build();
    private static final SdkField<S3DestinationConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Configuration").getter(IcebergDestinationConfiguration.getter(IcebergDestinationConfiguration::s3Configuration)).setter(IcebergDestinationConfiguration.setter(Builder::s3Configuration)).constructor(S3DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_TABLE_CONFIGURATION_LIST_FIELD, BUFFERING_HINTS_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, S3_BACKUP_MODE_FIELD, RETRY_OPTIONS_FIELD, ROLE_ARN_FIELD, CATALOG_CONFIGURATION_FIELD, S3_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DestinationTableConfiguration> destinationTableConfigurationList;
    private final BufferingHints bufferingHints;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final RetryOptions retryOptions;
    private final String roleARN;
    private final CatalogConfiguration catalogConfiguration;
    private final S3DestinationConfiguration s3Configuration;

    private IcebergDestinationConfiguration(BuilderImpl builder) {
        this.destinationTableConfigurationList = builder.destinationTableConfigurationList;
        this.bufferingHints = builder.bufferingHints;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.retryOptions = builder.retryOptions;
        this.roleARN = builder.roleARN;
        this.catalogConfiguration = builder.catalogConfiguration;
        this.s3Configuration = builder.s3Configuration;
    }

    public final boolean hasDestinationTableConfigurationList() {
        return this.destinationTableConfigurationList != null && !(this.destinationTableConfigurationList instanceof SdkAutoConstructList);
    }

    public final List<DestinationTableConfiguration> destinationTableConfigurationList() {
        return this.destinationTableConfigurationList;
    }

    public final BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final IcebergS3BackupMode s3BackupMode() {
        return IcebergS3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final CatalogConfiguration catalogConfiguration() {
        return this.catalogConfiguration;
    }

    public final S3DestinationConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationTableConfigurationList() ? this.destinationTableConfigurationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergDestinationConfiguration)) {
            return false;
        }
        IcebergDestinationConfiguration other = (IcebergDestinationConfiguration)obj;
        return this.hasDestinationTableConfigurationList() == other.hasDestinationTableConfigurationList() && Objects.equals(this.destinationTableConfigurationList(), other.destinationTableConfigurationList()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.catalogConfiguration(), other.catalogConfiguration()) && Objects.equals(this.s3Configuration(), other.s3Configuration());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergDestinationConfiguration").add("DestinationTableConfigurationList", this.hasDestinationTableConfigurationList() ? this.destinationTableConfigurationList() : null).add("BufferingHints", (Object)this.bufferingHints()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("RetryOptions", (Object)this.retryOptions()).add("RoleARN", (Object)this.roleARN()).add("CatalogConfiguration", (Object)this.catalogConfiguration()).add("S3Configuration", (Object)this.s3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationTableConfigurationList": {
                return Optional.ofNullable(clazz.cast(this.destinationTableConfigurationList()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "CatalogConfiguration": {
                return Optional.ofNullable(clazz.cast(this.catalogConfiguration()));
            }
            case "S3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IcebergDestinationConfiguration, T> g) {
        return obj -> g.apply((IcebergDestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DestinationTableConfiguration> destinationTableConfigurationList = DefaultSdkAutoConstructList.getInstance();
        private BufferingHints bufferingHints;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private RetryOptions retryOptions;
        private String roleARN;
        private CatalogConfiguration catalogConfiguration;
        private S3DestinationConfiguration s3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergDestinationConfiguration model) {
            this.destinationTableConfigurationList(model.destinationTableConfigurationList);
            this.bufferingHints(model.bufferingHints);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.retryOptions(model.retryOptions);
            this.roleARN(model.roleARN);
            this.catalogConfiguration(model.catalogConfiguration);
            this.s3Configuration(model.s3Configuration);
        }

        public final List<DestinationTableConfiguration.Builder> getDestinationTableConfigurationList() {
            List<DestinationTableConfiguration.Builder> result = DestinationTableConfigurationListCopier.copyToBuilder(this.destinationTableConfigurationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationTableConfigurationList(Collection<DestinationTableConfiguration.BuilderImpl> destinationTableConfigurationList) {
            this.destinationTableConfigurationList = DestinationTableConfigurationListCopier.copyFromBuilder(destinationTableConfigurationList);
        }

        @Override
        public final Builder destinationTableConfigurationList(Collection<DestinationTableConfiguration> destinationTableConfigurationList) {
            this.destinationTableConfigurationList = DestinationTableConfigurationListCopier.copy(destinationTableConfigurationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationTableConfigurationList(DestinationTableConfiguration ... destinationTableConfigurationList) {
            this.destinationTableConfigurationList(Arrays.asList(destinationTableConfigurationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationTableConfigurationList(Consumer<DestinationTableConfiguration.Builder> ... destinationTableConfigurationList) {
            this.destinationTableConfigurationList(Stream.of(destinationTableConfigurationList).map(c -> (DestinationTableConfiguration)((DestinationTableConfiguration.Builder)DestinationTableConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(IcebergS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final RetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        public final void setRetryOptions(RetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        @Override
        public final Builder retryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final CatalogConfiguration.Builder getCatalogConfiguration() {
            return this.catalogConfiguration != null ? this.catalogConfiguration.toBuilder() : null;
        }

        public final void setCatalogConfiguration(CatalogConfiguration.BuilderImpl catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration != null ? catalogConfiguration.build() : null;
        }

        @Override
        public final Builder catalogConfiguration(CatalogConfiguration catalogConfiguration) {
            this.catalogConfiguration = catalogConfiguration;
            return this;
        }

        public final S3DestinationConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DestinationConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DestinationConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public IcebergDestinationConfiguration build() {
            return new IcebergDestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergDestinationConfiguration> {
        public Builder destinationTableConfigurationList(Collection<DestinationTableConfiguration> var1);

        public Builder destinationTableConfigurationList(DestinationTableConfiguration ... var1);

        public Builder destinationTableConfigurationList(Consumer<DestinationTableConfiguration.Builder> ... var1);

        public Builder bufferingHints(BufferingHints var1);

        default public Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((BufferingHints)((BufferingHints.Builder)BufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(IcebergS3BackupMode var1);

        public Builder retryOptions(RetryOptions var1);

        default public Builder retryOptions(Consumer<RetryOptions.Builder> retryOptions) {
            return this.retryOptions((RetryOptions)((RetryOptions.Builder)RetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder roleARN(String var1);

        public Builder catalogConfiguration(CatalogConfiguration var1);

        default public Builder catalogConfiguration(Consumer<CatalogConfiguration.Builder> catalogConfiguration) {
            return this.catalogConfiguration((CatalogConfiguration)((CatalogConfiguration.Builder)CatalogConfiguration.builder().applyMutation(catalogConfiguration)).build());
        }

        public Builder s3Configuration(S3DestinationConfiguration var1);

        default public Builder s3Configuration(Consumer<S3DestinationConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3DestinationConfiguration)((S3DestinationConfiguration.Builder)S3DestinationConfiguration.builder().applyMutation(s3Configuration)).build());
        }
    }
}

