/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KMSEncryptionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KMSEncryptionConfig> {
    private static final SdkField<String> AWSKMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(KMSEncryptionConfig.getter(KMSEncryptionConfig::awskmsKeyARN)).setter(KMSEncryptionConfig.setter(Builder::awskmsKeyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSKMSKeyARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWSKMS_KEY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awskmsKeyARN;

    private KMSEncryptionConfig(BuilderImpl builder) {
        this.awskmsKeyARN = builder.awskmsKeyARN;
    }

    public String awskmsKeyARN() {
        return this.awskmsKeyARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awskmsKeyARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KMSEncryptionConfig)) {
            return false;
        }
        KMSEncryptionConfig other = (KMSEncryptionConfig)obj;
        return Objects.equals(this.awskmsKeyARN(), other.awskmsKeyARN());
    }

    public String toString() {
        return ToString.builder((String)"KMSEncryptionConfig").add("AWSKMSKeyARN", (Object)this.awskmsKeyARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSKMSKeyARN": {
                return Optional.ofNullable(clazz.cast(this.awskmsKeyARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KMSEncryptionConfig, T> g) {
        return obj -> g.apply((KMSEncryptionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awskmsKeyARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KMSEncryptionConfig model) {
            this.awskmsKeyARN(model.awskmsKeyARN);
        }

        public final String getAWSKMSKeyARN() {
            return this.awskmsKeyARN;
        }

        @Override
        public final Builder awskmsKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
            return this;
        }

        public final void setAWSKMSKeyARN(String awskmsKeyARN) {
            this.awskmsKeyARN = awskmsKeyARN;
        }

        public KMSEncryptionConfig build() {
            return new KMSEncryptionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KMSEncryptionConfig> {
        public Builder awskmsKeyARN(String var1);
    }
}

