/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.BufferingHints;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CompressionFormat;
import software.amazon.awssdk.services.firehose.model.DataFormatConversionConfiguration;
import software.amazon.awssdk.services.firehose.model.EncryptionConfiguration;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExtendedS3DestinationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExtendedS3DestinationDescription> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::roleARN)).setter(ExtendedS3DestinationDescription.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARN").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::bucketARN)).setter(ExtendedS3DestinationDescription.setter(Builder::bucketARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::prefix)).setter(ExtendedS3DestinationDescription.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> ERROR_OUTPUT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorOutputPrefix").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::errorOutputPrefix)).setter(ExtendedS3DestinationDescription.setter(Builder::errorOutputPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorOutputPrefix").build()}).build();
    private static final SdkField<BufferingHints> BUFFERING_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BufferingHints").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::bufferingHints)).setter(ExtendedS3DestinationDescription.setter(Builder::bufferingHints)).constructor(BufferingHints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BufferingHints").build()}).build();
    private static final SdkField<String> COMPRESSION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionFormat").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::compressionFormatAsString)).setter(ExtendedS3DestinationDescription.setter(Builder::compressionFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionFormat").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionConfiguration").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::encryptionConfiguration)).setter(ExtendedS3DestinationDescription.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOptions").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::cloudWatchLoggingOptions)).setter(ExtendedS3DestinationDescription.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessingConfiguration").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::processingConfiguration)).setter(ExtendedS3DestinationDescription.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BackupMode").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::s3BackupModeAsString)).setter(ExtendedS3DestinationDescription.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationDescription> S3_BACKUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3BackupDescription").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::s3BackupDescription)).setter(ExtendedS3DestinationDescription.setter(Builder::s3BackupDescription)).constructor(S3DestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupDescription").build()}).build();
    private static final SdkField<DataFormatConversionConfiguration> DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataFormatConversionConfiguration").getter(ExtendedS3DestinationDescription.getter(ExtendedS3DestinationDescription::dataFormatConversionConfiguration)).setter(ExtendedS3DestinationDescription.setter(Builder::dataFormatConversionConfiguration)).constructor(DataFormatConversionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormatConversionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, BUCKET_ARN_FIELD, PREFIX_FIELD, ERROR_OUTPUT_PREFIX_FIELD, BUFFERING_HINTS_FIELD, COMPRESSION_FORMAT_FIELD, ENCRYPTION_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD, PROCESSING_CONFIGURATION_FIELD, S3_BACKUP_MODE_FIELD, S3_BACKUP_DESCRIPTION_FIELD, DATA_FORMAT_CONVERSION_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleARN;
    private final String bucketARN;
    private final String prefix;
    private final String errorOutputPrefix;
    private final BufferingHints bufferingHints;
    private final String compressionFormat;
    private final EncryptionConfiguration encryptionConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationDescription s3BackupDescription;
    private final DataFormatConversionConfiguration dataFormatConversionConfiguration;

    private ExtendedS3DestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.bucketARN = builder.bucketARN;
        this.prefix = builder.prefix;
        this.errorOutputPrefix = builder.errorOutputPrefix;
        this.bufferingHints = builder.bufferingHints;
        this.compressionFormat = builder.compressionFormat;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupDescription = builder.s3BackupDescription;
        this.dataFormatConversionConfiguration = builder.dataFormatConversionConfiguration;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final String bucketARN() {
        return this.bucketARN;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String errorOutputPrefix() {
        return this.errorOutputPrefix;
    }

    public final BufferingHints bufferingHints() {
        return this.bufferingHints;
    }

    public final CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(this.compressionFormat);
    }

    public final String compressionFormatAsString() {
        return this.compressionFormat;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public final ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public final S3BackupMode s3BackupMode() {
        return S3BackupMode.fromValue(this.s3BackupMode);
    }

    public final String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public final S3DestinationDescription s3BackupDescription() {
        return this.s3BackupDescription;
    }

    public final DataFormatConversionConfiguration dataFormatConversionConfiguration() {
        return this.dataFormatConversionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorOutputPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatConversionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedS3DestinationDescription)) {
            return false;
        }
        ExtendedS3DestinationDescription other = (ExtendedS3DestinationDescription)obj;
        return Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.bucketARN(), other.bucketARN()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.errorOutputPrefix(), other.errorOutputPrefix()) && Objects.equals(this.bufferingHints(), other.bufferingHints()) && Objects.equals(this.compressionFormatAsString(), other.compressionFormatAsString()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3BackupDescription(), other.s3BackupDescription()) && Objects.equals(this.dataFormatConversionConfiguration(), other.dataFormatConversionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ExtendedS3DestinationDescription").add("RoleARN", (Object)this.roleARN()).add("BucketARN", (Object)this.bucketARN()).add("Prefix", (Object)this.prefix()).add("ErrorOutputPrefix", (Object)this.errorOutputPrefix()).add("BufferingHints", (Object)this.bufferingHints()).add("CompressionFormat", (Object)this.compressionFormatAsString()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3BackupDescription", (Object)this.s3BackupDescription()).add("DataFormatConversionConfiguration", (Object)this.dataFormatConversionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "BucketARN": {
                return Optional.ofNullable(clazz.cast(this.bucketARN()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "ErrorOutputPrefix": {
                return Optional.ofNullable(clazz.cast(this.errorOutputPrefix()));
            }
            case "BufferingHints": {
                return Optional.ofNullable(clazz.cast(this.bufferingHints()));
            }
            case "CompressionFormat": {
                return Optional.ofNullable(clazz.cast(this.compressionFormatAsString()));
            }
            case "EncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3BackupDescription": {
                return Optional.ofNullable(clazz.cast(this.s3BackupDescription()));
            }
            case "DataFormatConversionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataFormatConversionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtendedS3DestinationDescription, T> g) {
        return obj -> g.apply((ExtendedS3DestinationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String bucketARN;
        private String prefix;
        private String errorOutputPrefix;
        private BufferingHints bufferingHints;
        private String compressionFormat;
        private EncryptionConfiguration encryptionConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationDescription s3BackupDescription;
        private DataFormatConversionConfiguration dataFormatConversionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtendedS3DestinationDescription model) {
            this.roleARN(model.roleARN);
            this.bucketARN(model.bucketARN);
            this.prefix(model.prefix);
            this.errorOutputPrefix(model.errorOutputPrefix);
            this.bufferingHints(model.bufferingHints);
            this.compressionFormat(model.compressionFormat);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            this.processingConfiguration(model.processingConfiguration);
            this.s3BackupMode(model.s3BackupMode);
            this.s3BackupDescription(model.s3BackupDescription);
            this.dataFormatConversionConfiguration(model.dataFormatConversionConfiguration);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        @Transient
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getBucketARN() {
            return this.bucketARN;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        @Override
        @Transient
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        @Transient
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getErrorOutputPrefix() {
            return this.errorOutputPrefix;
        }

        public final void setErrorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
        }

        @Override
        @Transient
        public final Builder errorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        public final BufferingHints.Builder getBufferingHints() {
            return this.bufferingHints != null ? this.bufferingHints.toBuilder() : null;
        }

        public final void setBufferingHints(BufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        @Override
        @Transient
        public final Builder bufferingHints(BufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        @Override
        @Transient
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat == null ? null : compressionFormat.toString());
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        @Override
        @Transient
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        @Transient
        public final Builder s3BackupMode(S3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode == null ? null : s3BackupMode.toString());
            return this;
        }

        public final S3DestinationDescription.Builder getS3BackupDescription() {
            return this.s3BackupDescription != null ? this.s3BackupDescription.toBuilder() : null;
        }

        public final void setS3BackupDescription(S3DestinationDescription.BuilderImpl s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription != null ? s3BackupDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder s3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
            return this;
        }

        public final DataFormatConversionConfiguration.Builder getDataFormatConversionConfiguration() {
            return this.dataFormatConversionConfiguration != null ? this.dataFormatConversionConfiguration.toBuilder() : null;
        }

        public final void setDataFormatConversionConfiguration(DataFormatConversionConfiguration.BuilderImpl dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration != null ? dataFormatConversionConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration dataFormatConversionConfiguration) {
            this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
            return this;
        }

        public ExtendedS3DestinationDescription build() {
            return new ExtendedS3DestinationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExtendedS3DestinationDescription> {
        public Builder roleARN(String var1);

        public Builder bucketARN(String var1);

        public Builder prefix(String var1);

        public Builder errorOutputPrefix(String var1);

        public Builder bufferingHints(BufferingHints var1);

        default public Builder bufferingHints(Consumer<BufferingHints.Builder> bufferingHints) {
            return this.bufferingHints((BufferingHints)((BufferingHints.Builder)BufferingHints.builder().applyMutation(bufferingHints)).build());
        }

        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(S3BackupMode var1);

        public Builder s3BackupDescription(S3DestinationDescription var1);

        default public Builder s3BackupDescription(Consumer<S3DestinationDescription.Builder> s3BackupDescription) {
            return this.s3BackupDescription((S3DestinationDescription)((S3DestinationDescription.Builder)S3DestinationDescription.builder().applyMutation(s3BackupDescription)).build());
        }

        public Builder dataFormatConversionConfiguration(DataFormatConversionConfiguration var1);

        default public Builder dataFormatConversionConfiguration(Consumer<DataFormatConversionConfiguration.Builder> dataFormatConversionConfiguration) {
            return this.dataFormatConversionConfiguration((DataFormatConversionConfiguration)((DataFormatConversionConfiguration.Builder)DataFormatConversionConfiguration.builder().applyMutation(dataFormatConversionConfiguration)).build());
        }
    }
}

