/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.ElasticsearchDestinationUpdate;
import software.amazon.awssdk.services.firehose.model.ExtendedS3DestinationUpdate;
import software.amazon.awssdk.services.firehose.model.FirehoseRequest;
import software.amazon.awssdk.services.firehose.model.HttpEndpointDestinationUpdate;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationUpdate;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.services.firehose.model.SplunkDestinationUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDestinationRequest
extends FirehoseRequest
implements ToCopyableBuilder<Builder, UpdateDestinationRequest> {
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::deliveryStreamName)).setter(UpdateDestinationRequest.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStreamName").build()}).build();
    private static final SdkField<String> CURRENT_DELIVERY_STREAM_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::currentDeliveryStreamVersionId)).setter(UpdateDestinationRequest.setter(Builder::currentDeliveryStreamVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentDeliveryStreamVersionId").build()}).build();
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::destinationId)).setter(UpdateDestinationRequest.setter(Builder::destinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationId").build()}).build();
    private static final SdkField<S3DestinationUpdate> S3_DESTINATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::s3DestinationUpdate)).setter(UpdateDestinationRequest.setter(Builder::s3DestinationUpdate)).constructor(S3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DestinationUpdate").build()}).build();
    private static final SdkField<ExtendedS3DestinationUpdate> EXTENDED_S3_DESTINATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::extendedS3DestinationUpdate)).setter(UpdateDestinationRequest.setter(Builder::extendedS3DestinationUpdate)).constructor(ExtendedS3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtendedS3DestinationUpdate").build()}).build();
    private static final SdkField<RedshiftDestinationUpdate> REDSHIFT_DESTINATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::redshiftDestinationUpdate)).setter(UpdateDestinationRequest.setter(Builder::redshiftDestinationUpdate)).constructor(RedshiftDestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDestinationUpdate").build()}).build();
    private static final SdkField<ElasticsearchDestinationUpdate> ELASTICSEARCH_DESTINATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::elasticsearchDestinationUpdate)).setter(UpdateDestinationRequest.setter(Builder::elasticsearchDestinationUpdate)).constructor(ElasticsearchDestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchDestinationUpdate").build()}).build();
    private static final SdkField<SplunkDestinationUpdate> SPLUNK_DESTINATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::splunkDestinationUpdate)).setter(UpdateDestinationRequest.setter(Builder::splunkDestinationUpdate)).constructor(SplunkDestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplunkDestinationUpdate").build()}).build();
    private static final SdkField<HttpEndpointDestinationUpdate> HTTP_ENDPOINT_DESTINATION_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDestinationRequest.getter(UpdateDestinationRequest::httpEndpointDestinationUpdate)).setter(UpdateDestinationRequest.setter(Builder::httpEndpointDestinationUpdate)).constructor(HttpEndpointDestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointDestinationUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_NAME_FIELD, CURRENT_DELIVERY_STREAM_VERSION_ID_FIELD, DESTINATION_ID_FIELD, S3_DESTINATION_UPDATE_FIELD, EXTENDED_S3_DESTINATION_UPDATE_FIELD, REDSHIFT_DESTINATION_UPDATE_FIELD, ELASTICSEARCH_DESTINATION_UPDATE_FIELD, SPLUNK_DESTINATION_UPDATE_FIELD, HTTP_ENDPOINT_DESTINATION_UPDATE_FIELD));
    private final String deliveryStreamName;
    private final String currentDeliveryStreamVersionId;
    private final String destinationId;
    private final S3DestinationUpdate s3DestinationUpdate;
    private final ExtendedS3DestinationUpdate extendedS3DestinationUpdate;
    private final RedshiftDestinationUpdate redshiftDestinationUpdate;
    private final ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;
    private final SplunkDestinationUpdate splunkDestinationUpdate;
    private final HttpEndpointDestinationUpdate httpEndpointDestinationUpdate;

    private UpdateDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.currentDeliveryStreamVersionId = builder.currentDeliveryStreamVersionId;
        this.destinationId = builder.destinationId;
        this.s3DestinationUpdate = builder.s3DestinationUpdate;
        this.extendedS3DestinationUpdate = builder.extendedS3DestinationUpdate;
        this.redshiftDestinationUpdate = builder.redshiftDestinationUpdate;
        this.elasticsearchDestinationUpdate = builder.elasticsearchDestinationUpdate;
        this.splunkDestinationUpdate = builder.splunkDestinationUpdate;
        this.httpEndpointDestinationUpdate = builder.httpEndpointDestinationUpdate;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String currentDeliveryStreamVersionId() {
        return this.currentDeliveryStreamVersionId;
    }

    public String destinationId() {
        return this.destinationId;
    }

    public S3DestinationUpdate s3DestinationUpdate() {
        return this.s3DestinationUpdate;
    }

    public ExtendedS3DestinationUpdate extendedS3DestinationUpdate() {
        return this.extendedS3DestinationUpdate;
    }

    public RedshiftDestinationUpdate redshiftDestinationUpdate() {
        return this.redshiftDestinationUpdate;
    }

    public ElasticsearchDestinationUpdate elasticsearchDestinationUpdate() {
        return this.elasticsearchDestinationUpdate;
    }

    public SplunkDestinationUpdate splunkDestinationUpdate() {
        return this.splunkDestinationUpdate;
    }

    public HttpEndpointDestinationUpdate httpEndpointDestinationUpdate() {
        return this.httpEndpointDestinationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentDeliveryStreamVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedS3DestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.splunkDestinationUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointDestinationUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDestinationRequest)) {
            return false;
        }
        UpdateDestinationRequest other = (UpdateDestinationRequest)((Object)obj);
        return Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.currentDeliveryStreamVersionId(), other.currentDeliveryStreamVersionId()) && Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.s3DestinationUpdate(), other.s3DestinationUpdate()) && Objects.equals(this.extendedS3DestinationUpdate(), other.extendedS3DestinationUpdate()) && Objects.equals(this.redshiftDestinationUpdate(), other.redshiftDestinationUpdate()) && Objects.equals(this.elasticsearchDestinationUpdate(), other.elasticsearchDestinationUpdate()) && Objects.equals(this.splunkDestinationUpdate(), other.splunkDestinationUpdate()) && Objects.equals(this.httpEndpointDestinationUpdate(), other.httpEndpointDestinationUpdate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDestinationRequest").add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("CurrentDeliveryStreamVersionId", (Object)this.currentDeliveryStreamVersionId()).add("DestinationId", (Object)this.destinationId()).add("S3DestinationUpdate", (Object)this.s3DestinationUpdate()).add("ExtendedS3DestinationUpdate", (Object)this.extendedS3DestinationUpdate()).add("RedshiftDestinationUpdate", (Object)this.redshiftDestinationUpdate()).add("ElasticsearchDestinationUpdate", (Object)this.elasticsearchDestinationUpdate()).add("SplunkDestinationUpdate", (Object)this.splunkDestinationUpdate()).add("HttpEndpointDestinationUpdate", (Object)this.httpEndpointDestinationUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "CurrentDeliveryStreamVersionId": {
                return Optional.ofNullable(clazz.cast(this.currentDeliveryStreamVersionId()));
            }
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
            case "S3DestinationUpdate": {
                return Optional.ofNullable(clazz.cast(this.s3DestinationUpdate()));
            }
            case "ExtendedS3DestinationUpdate": {
                return Optional.ofNullable(clazz.cast(this.extendedS3DestinationUpdate()));
            }
            case "RedshiftDestinationUpdate": {
                return Optional.ofNullable(clazz.cast(this.redshiftDestinationUpdate()));
            }
            case "ElasticsearchDestinationUpdate": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchDestinationUpdate()));
            }
            case "SplunkDestinationUpdate": {
                return Optional.ofNullable(clazz.cast(this.splunkDestinationUpdate()));
            }
            case "HttpEndpointDestinationUpdate": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointDestinationUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDestinationRequest, T> g) {
        return obj -> g.apply((UpdateDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FirehoseRequest.BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String currentDeliveryStreamVersionId;
        private String destinationId;
        private S3DestinationUpdate s3DestinationUpdate;
        private ExtendedS3DestinationUpdate extendedS3DestinationUpdate;
        private RedshiftDestinationUpdate redshiftDestinationUpdate;
        private ElasticsearchDestinationUpdate elasticsearchDestinationUpdate;
        private SplunkDestinationUpdate splunkDestinationUpdate;
        private HttpEndpointDestinationUpdate httpEndpointDestinationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDestinationRequest model) {
            super(model);
            this.deliveryStreamName(model.deliveryStreamName);
            this.currentDeliveryStreamVersionId(model.currentDeliveryStreamVersionId);
            this.destinationId(model.destinationId);
            this.s3DestinationUpdate(model.s3DestinationUpdate);
            this.extendedS3DestinationUpdate(model.extendedS3DestinationUpdate);
            this.redshiftDestinationUpdate(model.redshiftDestinationUpdate);
            this.elasticsearchDestinationUpdate(model.elasticsearchDestinationUpdate);
            this.splunkDestinationUpdate(model.splunkDestinationUpdate);
            this.httpEndpointDestinationUpdate(model.httpEndpointDestinationUpdate);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getCurrentDeliveryStreamVersionId() {
            return this.currentDeliveryStreamVersionId;
        }

        @Override
        public final Builder currentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
            return this;
        }

        public final void setCurrentDeliveryStreamVersionId(String currentDeliveryStreamVersionId) {
            this.currentDeliveryStreamVersionId = currentDeliveryStreamVersionId;
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final S3DestinationUpdate.Builder getS3DestinationUpdate() {
            return this.s3DestinationUpdate != null ? this.s3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationUpdate(S3DestinationUpdate s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate;
            return this;
        }

        public final void setS3DestinationUpdate(S3DestinationUpdate.BuilderImpl s3DestinationUpdate) {
            this.s3DestinationUpdate = s3DestinationUpdate != null ? s3DestinationUpdate.build() : null;
        }

        public final ExtendedS3DestinationUpdate.Builder getExtendedS3DestinationUpdate() {
            return this.extendedS3DestinationUpdate != null ? this.extendedS3DestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate;
            return this;
        }

        public final void setExtendedS3DestinationUpdate(ExtendedS3DestinationUpdate.BuilderImpl extendedS3DestinationUpdate) {
            this.extendedS3DestinationUpdate = extendedS3DestinationUpdate != null ? extendedS3DestinationUpdate.build() : null;
        }

        public final RedshiftDestinationUpdate.Builder getRedshiftDestinationUpdate() {
            return this.redshiftDestinationUpdate != null ? this.redshiftDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder redshiftDestinationUpdate(RedshiftDestinationUpdate redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate;
            return this;
        }

        public final void setRedshiftDestinationUpdate(RedshiftDestinationUpdate.BuilderImpl redshiftDestinationUpdate) {
            this.redshiftDestinationUpdate = redshiftDestinationUpdate != null ? redshiftDestinationUpdate.build() : null;
        }

        public final ElasticsearchDestinationUpdate.Builder getElasticsearchDestinationUpdate() {
            return this.elasticsearchDestinationUpdate != null ? this.elasticsearchDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate;
            return this;
        }

        public final void setElasticsearchDestinationUpdate(ElasticsearchDestinationUpdate.BuilderImpl elasticsearchDestinationUpdate) {
            this.elasticsearchDestinationUpdate = elasticsearchDestinationUpdate != null ? elasticsearchDestinationUpdate.build() : null;
        }

        public final SplunkDestinationUpdate.Builder getSplunkDestinationUpdate() {
            return this.splunkDestinationUpdate != null ? this.splunkDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder splunkDestinationUpdate(SplunkDestinationUpdate splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate;
            return this;
        }

        public final void setSplunkDestinationUpdate(SplunkDestinationUpdate.BuilderImpl splunkDestinationUpdate) {
            this.splunkDestinationUpdate = splunkDestinationUpdate != null ? splunkDestinationUpdate.build() : null;
        }

        public final HttpEndpointDestinationUpdate.Builder getHttpEndpointDestinationUpdate() {
            return this.httpEndpointDestinationUpdate != null ? this.httpEndpointDestinationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder httpEndpointDestinationUpdate(HttpEndpointDestinationUpdate httpEndpointDestinationUpdate) {
            this.httpEndpointDestinationUpdate = httpEndpointDestinationUpdate;
            return this;
        }

        public final void setHttpEndpointDestinationUpdate(HttpEndpointDestinationUpdate.BuilderImpl httpEndpointDestinationUpdate) {
            this.httpEndpointDestinationUpdate = httpEndpointDestinationUpdate != null ? httpEndpointDestinationUpdate.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDestinationRequest build() {
            return new UpdateDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FirehoseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDestinationRequest> {
        public Builder deliveryStreamName(String var1);

        public Builder currentDeliveryStreamVersionId(String var1);

        public Builder destinationId(String var1);

        public Builder s3DestinationUpdate(S3DestinationUpdate var1);

        default public Builder s3DestinationUpdate(Consumer<S3DestinationUpdate.Builder> s3DestinationUpdate) {
            return this.s3DestinationUpdate((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3DestinationUpdate)).build());
        }

        public Builder extendedS3DestinationUpdate(ExtendedS3DestinationUpdate var1);

        default public Builder extendedS3DestinationUpdate(Consumer<ExtendedS3DestinationUpdate.Builder> extendedS3DestinationUpdate) {
            return this.extendedS3DestinationUpdate((ExtendedS3DestinationUpdate)((ExtendedS3DestinationUpdate.Builder)ExtendedS3DestinationUpdate.builder().applyMutation(extendedS3DestinationUpdate)).build());
        }

        public Builder redshiftDestinationUpdate(RedshiftDestinationUpdate var1);

        default public Builder redshiftDestinationUpdate(Consumer<RedshiftDestinationUpdate.Builder> redshiftDestinationUpdate) {
            return this.redshiftDestinationUpdate((RedshiftDestinationUpdate)((RedshiftDestinationUpdate.Builder)RedshiftDestinationUpdate.builder().applyMutation(redshiftDestinationUpdate)).build());
        }

        public Builder elasticsearchDestinationUpdate(ElasticsearchDestinationUpdate var1);

        default public Builder elasticsearchDestinationUpdate(Consumer<ElasticsearchDestinationUpdate.Builder> elasticsearchDestinationUpdate) {
            return this.elasticsearchDestinationUpdate((ElasticsearchDestinationUpdate)((ElasticsearchDestinationUpdate.Builder)ElasticsearchDestinationUpdate.builder().applyMutation(elasticsearchDestinationUpdate)).build());
        }

        public Builder splunkDestinationUpdate(SplunkDestinationUpdate var1);

        default public Builder splunkDestinationUpdate(Consumer<SplunkDestinationUpdate.Builder> splunkDestinationUpdate) {
            return this.splunkDestinationUpdate((SplunkDestinationUpdate)((SplunkDestinationUpdate.Builder)SplunkDestinationUpdate.builder().applyMutation(splunkDestinationUpdate)).build());
        }

        public Builder httpEndpointDestinationUpdate(HttpEndpointDestinationUpdate var1);

        default public Builder httpEndpointDestinationUpdate(Consumer<HttpEndpointDestinationUpdate.Builder> httpEndpointDestinationUpdate) {
            return this.httpEndpointDestinationUpdate((HttpEndpointDestinationUpdate)((HttpEndpointDestinationUpdate.Builder)HttpEndpointDestinationUpdate.builder().applyMutation(httpEndpointDestinationUpdate)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

