/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.firehose.model.ColumnToJsonKeyMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenXJsonSerDe
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenXJsonSerDe> {
    private static final SdkField<Boolean> CONVERT_DOTS_IN_JSON_KEYS_TO_UNDERSCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OpenXJsonSerDe.getter(OpenXJsonSerDe::convertDotsInJsonKeysToUnderscores)).setter(OpenXJsonSerDe.setter(Builder::convertDotsInJsonKeysToUnderscores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConvertDotsInJsonKeysToUnderscores").build()}).build();
    private static final SdkField<Boolean> CASE_INSENSITIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(OpenXJsonSerDe.getter(OpenXJsonSerDe::caseInsensitive)).setter(OpenXJsonSerDe.setter(Builder::caseInsensitive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseInsensitive").build()}).build();
    private static final SdkField<Map<String, String>> COLUMN_TO_JSON_KEY_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(OpenXJsonSerDe.getter(OpenXJsonSerDe::columnToJsonKeyMappings)).setter(OpenXJsonSerDe.setter(Builder::columnToJsonKeyMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnToJsonKeyMappings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERT_DOTS_IN_JSON_KEYS_TO_UNDERSCORES_FIELD, CASE_INSENSITIVE_FIELD, COLUMN_TO_JSON_KEY_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean convertDotsInJsonKeysToUnderscores;
    private final Boolean caseInsensitive;
    private final Map<String, String> columnToJsonKeyMappings;

    private OpenXJsonSerDe(BuilderImpl builder) {
        this.convertDotsInJsonKeysToUnderscores = builder.convertDotsInJsonKeysToUnderscores;
        this.caseInsensitive = builder.caseInsensitive;
        this.columnToJsonKeyMappings = builder.columnToJsonKeyMappings;
    }

    public Boolean convertDotsInJsonKeysToUnderscores() {
        return this.convertDotsInJsonKeysToUnderscores;
    }

    public Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean hasColumnToJsonKeyMappings() {
        return this.columnToJsonKeyMappings != null && !(this.columnToJsonKeyMappings instanceof SdkAutoConstructMap);
    }

    public Map<String, String> columnToJsonKeyMappings() {
        return this.columnToJsonKeyMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.convertDotsInJsonKeysToUnderscores());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseInsensitive());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnToJsonKeyMappings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenXJsonSerDe)) {
            return false;
        }
        OpenXJsonSerDe other = (OpenXJsonSerDe)obj;
        return Objects.equals(this.convertDotsInJsonKeysToUnderscores(), other.convertDotsInJsonKeysToUnderscores()) && Objects.equals(this.caseInsensitive(), other.caseInsensitive()) && Objects.equals(this.columnToJsonKeyMappings(), other.columnToJsonKeyMappings());
    }

    public String toString() {
        return ToString.builder((String)"OpenXJsonSerDe").add("ConvertDotsInJsonKeysToUnderscores", (Object)this.convertDotsInJsonKeysToUnderscores()).add("CaseInsensitive", (Object)this.caseInsensitive()).add("ColumnToJsonKeyMappings", this.columnToJsonKeyMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConvertDotsInJsonKeysToUnderscores": {
                return Optional.ofNullable(clazz.cast(this.convertDotsInJsonKeysToUnderscores()));
            }
            case "CaseInsensitive": {
                return Optional.ofNullable(clazz.cast(this.caseInsensitive()));
            }
            case "ColumnToJsonKeyMappings": {
                return Optional.ofNullable(clazz.cast(this.columnToJsonKeyMappings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenXJsonSerDe, T> g) {
        return obj -> g.apply((OpenXJsonSerDe)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean convertDotsInJsonKeysToUnderscores;
        private Boolean caseInsensitive;
        private Map<String, String> columnToJsonKeyMappings = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpenXJsonSerDe model) {
            this.convertDotsInJsonKeysToUnderscores(model.convertDotsInJsonKeysToUnderscores);
            this.caseInsensitive(model.caseInsensitive);
            this.columnToJsonKeyMappings(model.columnToJsonKeyMappings);
        }

        public final Boolean getConvertDotsInJsonKeysToUnderscores() {
            return this.convertDotsInJsonKeysToUnderscores;
        }

        @Override
        public final Builder convertDotsInJsonKeysToUnderscores(Boolean convertDotsInJsonKeysToUnderscores) {
            this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
            return this;
        }

        public final void setConvertDotsInJsonKeysToUnderscores(Boolean convertDotsInJsonKeysToUnderscores) {
            this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
        }

        public final Boolean getCaseInsensitive() {
            return this.caseInsensitive;
        }

        @Override
        public final Builder caseInsensitive(Boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            return this;
        }

        public final void setCaseInsensitive(Boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
        }

        public final Map<String, String> getColumnToJsonKeyMappings() {
            return this.columnToJsonKeyMappings;
        }

        @Override
        public final Builder columnToJsonKeyMappings(Map<String, String> columnToJsonKeyMappings) {
            this.columnToJsonKeyMappings = ColumnToJsonKeyMappingsCopier.copy(columnToJsonKeyMappings);
            return this;
        }

        public final void setColumnToJsonKeyMappings(Map<String, String> columnToJsonKeyMappings) {
            this.columnToJsonKeyMappings = ColumnToJsonKeyMappingsCopier.copy(columnToJsonKeyMappings);
        }

        public OpenXJsonSerDe build() {
            return new OpenXJsonSerDe(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenXJsonSerDe> {
        public Builder convertDotsInJsonKeysToUnderscores(Boolean var1);

        public Builder caseInsensitive(Boolean var1);

        public Builder columnToJsonKeyMappings(Map<String, String> var1);
    }
}

