/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.HECEndpointType;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.S3DestinationUpdate;
import software.amazon.awssdk.services.firehose.model.SplunkRetryOptions;
import software.amazon.awssdk.services.firehose.model.SplunkS3BackupMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SplunkDestinationUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SplunkDestinationUpdate> {
    private static final SdkField<String> HEC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::hecEndpoint)).setter(SplunkDestinationUpdate.setter(Builder::hecEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECEndpoint").build()}).build();
    private static final SdkField<String> HEC_ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::hecEndpointTypeAsString)).setter(SplunkDestinationUpdate.setter(Builder::hecEndpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECEndpointType").build()}).build();
    private static final SdkField<String> HEC_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::hecToken)).setter(SplunkDestinationUpdate.setter(Builder::hecToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECToken").build()}).build();
    private static final SdkField<Integer> HEC_ACKNOWLEDGMENT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::hecAcknowledgmentTimeoutInSeconds)).setter(SplunkDestinationUpdate.setter(Builder::hecAcknowledgmentTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HECAcknowledgmentTimeoutInSeconds").build()}).build();
    private static final SdkField<SplunkRetryOptions> RETRY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::retryOptions)).setter(SplunkDestinationUpdate.setter(Builder::retryOptions)).constructor(SplunkRetryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryOptions").build()}).build();
    private static final SdkField<String> S3_BACKUP_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::s3BackupModeAsString)).setter(SplunkDestinationUpdate.setter(Builder::s3BackupMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BackupMode").build()}).build();
    private static final SdkField<S3DestinationUpdate> S3_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::s3Update)).setter(SplunkDestinationUpdate.setter(Builder::s3Update)).constructor(S3DestinationUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Update").build()}).build();
    private static final SdkField<ProcessingConfiguration> PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::processingConfiguration)).setter(SplunkDestinationUpdate.setter(Builder::processingConfiguration)).constructor(ProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingConfiguration").build()}).build();
    private static final SdkField<CloudWatchLoggingOptions> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SplunkDestinationUpdate.getter(SplunkDestinationUpdate::cloudWatchLoggingOptions)).setter(SplunkDestinationUpdate.setter(Builder::cloudWatchLoggingOptions)).constructor(CloudWatchLoggingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEC_ENDPOINT_FIELD, HEC_ENDPOINT_TYPE_FIELD, HEC_TOKEN_FIELD, HEC_ACKNOWLEDGMENT_TIMEOUT_IN_SECONDS_FIELD, RETRY_OPTIONS_FIELD, S3_BACKUP_MODE_FIELD, S3_UPDATE_FIELD, PROCESSING_CONFIGURATION_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hecEndpoint;
    private final String hecEndpointType;
    private final String hecToken;
    private final Integer hecAcknowledgmentTimeoutInSeconds;
    private final SplunkRetryOptions retryOptions;
    private final String s3BackupMode;
    private final S3DestinationUpdate s3Update;
    private final ProcessingConfiguration processingConfiguration;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private SplunkDestinationUpdate(BuilderImpl builder) {
        this.hecEndpoint = builder.hecEndpoint;
        this.hecEndpointType = builder.hecEndpointType;
        this.hecToken = builder.hecToken;
        this.hecAcknowledgmentTimeoutInSeconds = builder.hecAcknowledgmentTimeoutInSeconds;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String hecEndpoint() {
        return this.hecEndpoint;
    }

    public HECEndpointType hecEndpointType() {
        return HECEndpointType.fromValue(this.hecEndpointType);
    }

    public String hecEndpointTypeAsString() {
        return this.hecEndpointType;
    }

    public String hecToken() {
        return this.hecToken;
    }

    public Integer hecAcknowledgmentTimeoutInSeconds() {
        return this.hecAcknowledgmentTimeoutInSeconds;
    }

    public SplunkRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public SplunkS3BackupMode s3BackupMode() {
        return SplunkS3BackupMode.fromValue(this.s3BackupMode);
    }

    public String s3BackupModeAsString() {
        return this.s3BackupMode;
    }

    public S3DestinationUpdate s3Update() {
        return this.s3Update;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hecEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecEndpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hecAcknowledgmentTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLoggingOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplunkDestinationUpdate)) {
            return false;
        }
        SplunkDestinationUpdate other = (SplunkDestinationUpdate)obj;
        return Objects.equals(this.hecEndpoint(), other.hecEndpoint()) && Objects.equals(this.hecEndpointTypeAsString(), other.hecEndpointTypeAsString()) && Objects.equals(this.hecToken(), other.hecToken()) && Objects.equals(this.hecAcknowledgmentTimeoutInSeconds(), other.hecAcknowledgmentTimeoutInSeconds()) && Objects.equals(this.retryOptions(), other.retryOptions()) && Objects.equals(this.s3BackupModeAsString(), other.s3BackupModeAsString()) && Objects.equals(this.s3Update(), other.s3Update()) && Objects.equals(this.processingConfiguration(), other.processingConfiguration()) && Objects.equals(this.cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    public String toString() {
        return ToString.builder((String)"SplunkDestinationUpdate").add("HECEndpoint", (Object)this.hecEndpoint()).add("HECEndpointType", (Object)this.hecEndpointTypeAsString()).add("HECToken", (Object)this.hecToken()).add("HECAcknowledgmentTimeoutInSeconds", (Object)this.hecAcknowledgmentTimeoutInSeconds()).add("RetryOptions", (Object)this.retryOptions()).add("S3BackupMode", (Object)this.s3BackupModeAsString()).add("S3Update", (Object)this.s3Update()).add("ProcessingConfiguration", (Object)this.processingConfiguration()).add("CloudWatchLoggingOptions", (Object)this.cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HECEndpoint": {
                return Optional.ofNullable(clazz.cast(this.hecEndpoint()));
            }
            case "HECEndpointType": {
                return Optional.ofNullable(clazz.cast(this.hecEndpointTypeAsString()));
            }
            case "HECToken": {
                return Optional.ofNullable(clazz.cast(this.hecToken()));
            }
            case "HECAcknowledgmentTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.hecAcknowledgmentTimeoutInSeconds()));
            }
            case "RetryOptions": {
                return Optional.ofNullable(clazz.cast(this.retryOptions()));
            }
            case "S3BackupMode": {
                return Optional.ofNullable(clazz.cast(this.s3BackupModeAsString()));
            }
            case "S3Update": {
                return Optional.ofNullable(clazz.cast(this.s3Update()));
            }
            case "ProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.processingConfiguration()));
            }
            case "CloudWatchLoggingOptions": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLoggingOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SplunkDestinationUpdate, T> g) {
        return obj -> g.apply((SplunkDestinationUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hecEndpoint;
        private String hecEndpointType;
        private String hecToken;
        private Integer hecAcknowledgmentTimeoutInSeconds;
        private SplunkRetryOptions retryOptions;
        private String s3BackupMode;
        private S3DestinationUpdate s3Update;
        private ProcessingConfiguration processingConfiguration;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(SplunkDestinationUpdate model) {
            this.hecEndpoint(model.hecEndpoint);
            this.hecEndpointType(model.hecEndpointType);
            this.hecToken(model.hecToken);
            this.hecAcknowledgmentTimeoutInSeconds(model.hecAcknowledgmentTimeoutInSeconds);
            this.retryOptions(model.retryOptions);
            this.s3BackupMode(model.s3BackupMode);
            this.s3Update(model.s3Update);
            this.processingConfiguration(model.processingConfiguration);
            this.cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getHECEndpoint() {
            return this.hecEndpoint;
        }

        @Override
        public final Builder hecEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
            return this;
        }

        public final void setHECEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
        }

        public final String getHECEndpointType() {
            return this.hecEndpointType;
        }

        @Override
        public final Builder hecEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
            return this;
        }

        @Override
        public final Builder hecEndpointType(HECEndpointType hecEndpointType) {
            this.hecEndpointType(hecEndpointType.toString());
            return this;
        }

        public final void setHECEndpointType(String hecEndpointType) {
            this.hecEndpointType = hecEndpointType;
        }

        public final String getHECToken() {
            return this.hecToken;
        }

        @Override
        public final Builder hecToken(String hecToken) {
            this.hecToken = hecToken;
            return this;
        }

        public final void setHECToken(String hecToken) {
            this.hecToken = hecToken;
        }

        public final Integer getHECAcknowledgmentTimeoutInSeconds() {
            return this.hecAcknowledgmentTimeoutInSeconds;
        }

        @Override
        public final Builder hecAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
            return this;
        }

        public final void setHECAcknowledgmentTimeoutInSeconds(Integer hecAcknowledgmentTimeoutInSeconds) {
            this.hecAcknowledgmentTimeoutInSeconds = hecAcknowledgmentTimeoutInSeconds;
        }

        public final SplunkRetryOptions.Builder getRetryOptions() {
            return this.retryOptions != null ? this.retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(SplunkRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(SplunkRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(SplunkS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return this.s3Update != null ? this.s3Update.toBuilder() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return this.processingConfiguration != null ? this.processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        public SplunkDestinationUpdate build() {
            return new SplunkDestinationUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SplunkDestinationUpdate> {
        public Builder hecEndpoint(String var1);

        public Builder hecEndpointType(String var1);

        public Builder hecEndpointType(HECEndpointType var1);

        public Builder hecToken(String var1);

        public Builder hecAcknowledgmentTimeoutInSeconds(Integer var1);

        public Builder retryOptions(SplunkRetryOptions var1);

        default public Builder retryOptions(Consumer<SplunkRetryOptions.Builder> retryOptions) {
            return this.retryOptions((SplunkRetryOptions)((SplunkRetryOptions.Builder)SplunkRetryOptions.builder().applyMutation(retryOptions)).build());
        }

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(SplunkS3BackupMode var1);

        public Builder s3Update(S3DestinationUpdate var1);

        default public Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return this.s3Update((S3DestinationUpdate)((S3DestinationUpdate.Builder)S3DestinationUpdate.builder().applyMutation(s3Update)).build());
        }

        public Builder processingConfiguration(ProcessingConfiguration var1);

        default public Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return this.processingConfiguration((ProcessingConfiguration)((ProcessingConfiguration.Builder)ProcessingConfiguration.builder().applyMutation(processingConfiguration)).build());
        }

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);

        default public Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return this.cloudWatchLoggingOptions((CloudWatchLoggingOptions)((CloudWatchLoggingOptions.Builder)CloudWatchLoggingOptions.builder().applyMutation(cloudWatchLoggingOptions)).build());
        }
    }
}

