/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.AvailabilityZoneIdsCopier;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxVolumeStatus;
import software.amazon.awssdk.services.finspace.model.KxVolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxVolume> {
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeName").getter(KxVolume.getter(KxVolume::volumeName)).setter(KxVolume.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeName").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeType").getter(KxVolume.getter(KxVolume::volumeTypeAsString)).setter(KxVolume.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(KxVolume.getter(KxVolume::statusAsString)).setter(KxVolume.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(KxVolume.getter(KxVolume::description)).setter(KxVolume.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(KxVolume.getter(KxVolume::statusReason)).setter(KxVolume.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(KxVolume.getter(KxVolume::azModeAsString)).setter(KxVolume.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("availabilityZoneIds").getter(KxVolume.getter(KxVolume::availabilityZoneIds)).setter(KxVolume.setter(Builder::availabilityZoneIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(KxVolume.getter(KxVolume::createdTimestamp)).setter(KxVolume.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(KxVolume.getter(KxVolume::lastModifiedTimestamp)).setter(KxVolume.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_NAME_FIELD, VOLUME_TYPE_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, STATUS_REASON_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_IDS_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KxVolume.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String volumeName;
    private final String volumeType;
    private final String status;
    private final String description;
    private final String statusReason;
    private final String azMode;
    private final List<String> availabilityZoneIds;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;

    private KxVolume(BuilderImpl builder) {
        this.volumeName = builder.volumeName;
        this.volumeType = builder.volumeType;
        this.status = builder.status;
        this.description = builder.description;
        this.statusReason = builder.statusReason;
        this.azMode = builder.azMode;
        this.availabilityZoneIds = builder.availabilityZoneIds;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final KxVolumeType volumeType() {
        return KxVolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final KxVolumeStatus status() {
        return KxVolumeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final boolean hasAvailabilityZoneIds() {
        return this.availabilityZoneIds != null && !(this.availabilityZoneIds instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZoneIds() {
        return this.availabilityZoneIds;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxVolume)) {
            return false;
        }
        KxVolume other = (KxVolume)obj;
        return Objects.equals(this.volumeName(), other.volumeName()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && this.hasAvailabilityZoneIds() == other.hasAvailabilityZoneIds() && Objects.equals(this.availabilityZoneIds(), other.availabilityZoneIds()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"KxVolume").add("VolumeName", (Object)this.volumeName()).add("VolumeType", (Object)this.volumeTypeAsString()).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("StatusReason", (Object)this.statusReason()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneIds", this.hasAvailabilityZoneIds() ? this.availabilityZoneIds() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "volumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "volumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneIds": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneIds()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("volumeName", VOLUME_NAME_FIELD);
        map.put("volumeType", VOLUME_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("azMode", AZ_MODE_FIELD);
        map.put("availabilityZoneIds", AVAILABILITY_ZONE_IDS_FIELD);
        map.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KxVolume, T> g) {
        return obj -> g.apply((KxVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeName;
        private String volumeType;
        private String status;
        private String description;
        private String statusReason;
        private String azMode;
        private List<String> availabilityZoneIds = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KxVolume model) {
            this.volumeName(model.volumeName);
            this.volumeType(model.volumeType);
            this.status(model.status);
            this.description(model.description);
            this.statusReason(model.statusReason);
            this.azMode(model.azMode);
            this.availabilityZoneIds(model.availabilityZoneIds);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(KxVolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxVolumeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final Collection<String> getAvailabilityZoneIds() {
            if (this.availabilityZoneIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZoneIds;
        }

        public final void setAvailabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
        }

        @Override
        public final Builder availabilityZoneIds(Collection<String> availabilityZoneIds) {
            this.availabilityZoneIds = AvailabilityZoneIdsCopier.copy(availabilityZoneIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZoneIds(String ... availabilityZoneIds) {
            this.availabilityZoneIds(Arrays.asList(availabilityZoneIds));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public KxVolume build() {
            return new KxVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxVolume> {
        public Builder volumeName(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(KxVolumeType var1);

        public Builder status(String var1);

        public Builder status(KxVolumeStatus var1);

        public Builder description(String var1);

        public Builder statusReason(String var1);

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneIds(Collection<String> var1);

        public Builder availabilityZoneIds(String ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);
    }
}

