/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.ChangeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeRequest> {
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeType").getter(ChangeRequest.getter(ChangeRequest::changeTypeAsString)).setter(ChangeRequest.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeType").build()}).build();
    private static final SdkField<String> S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Path").getter(ChangeRequest.getter(ChangeRequest::s3Path)).setter(ChangeRequest.setter(Builder::s3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Path").build()}).build();
    private static final SdkField<String> DB_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbPath").getter(ChangeRequest.getter(ChangeRequest::dbPath)).setter(ChangeRequest.setter(Builder::dbPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_TYPE_FIELD, S3_PATH_FIELD, DB_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String changeType;
    private final String s3Path;
    private final String dbPath;

    private ChangeRequest(BuilderImpl builder) {
        this.changeType = builder.changeType;
        this.s3Path = builder.s3Path;
        this.dbPath = builder.dbPath;
    }

    public final ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public final String changeTypeAsString() {
        return this.changeType;
    }

    public final String s3Path() {
        return this.s3Path;
    }

    public final String dbPath() {
        return this.dbPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeRequest)) {
            return false;
        }
        ChangeRequest other = (ChangeRequest)obj;
        return Objects.equals(this.changeTypeAsString(), other.changeTypeAsString()) && Objects.equals(this.s3Path(), other.s3Path()) && Objects.equals(this.dbPath(), other.dbPath());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeRequest").add("ChangeType", (Object)this.changeTypeAsString()).add("S3Path", (Object)this.s3Path()).add("DbPath", (Object)this.dbPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
            case "s3Path": {
                return Optional.ofNullable(clazz.cast(this.s3Path()));
            }
            case "dbPath": {
                return Optional.ofNullable(clazz.cast(this.dbPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("changeType", CHANGE_TYPE_FIELD);
        map.put("s3Path", S3_PATH_FIELD);
        map.put("dbPath", DB_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeRequest, T> g) {
        return obj -> g.apply((ChangeRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changeType;
        private String s3Path;
        private String dbPath;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeRequest model) {
            this.changeType(model.changeType);
            this.s3Path(model.s3Path);
            this.dbPath(model.dbPath);
        }

        public final String getChangeType() {
            return this.changeType;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType == null ? null : changeType.toString());
            return this;
        }

        public final String getS3Path() {
            return this.s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getDbPath() {
            return this.dbPath;
        }

        public final void setDbPath(String dbPath) {
            this.dbPath = dbPath;
        }

        @Override
        public final Builder dbPath(String dbPath) {
            this.dbPath = dbPath;
            return this;
        }

        public ChangeRequest build() {
            return new ChangeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeRequest> {
        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);

        public Builder s3Path(String var1);

        public Builder dbPath(String var1);
    }
}

