/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.CodeConfiguration;
import software.amazon.awssdk.services.finspace.model.FinspaceRequest;
import software.amazon.awssdk.services.finspace.model.KxClusterCodeDeploymentConfiguration;
import software.amazon.awssdk.services.finspace.model.KxCommandLineArgument;
import software.amazon.awssdk.services.finspace.model.KxCommandLineArgumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateKxClusterCodeConfigurationRequest
extends FinspaceRequest
implements ToCopyableBuilder<Builder, UpdateKxClusterCodeConfigurationRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateKxClusterCodeConfigurationRequest.getter(UpdateKxClusterCodeConfigurationRequest::environmentId)).setter(UpdateKxClusterCodeConfigurationRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(UpdateKxClusterCodeConfigurationRequest.getter(UpdateKxClusterCodeConfigurationRequest::clusterName)).setter(UpdateKxClusterCodeConfigurationRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateKxClusterCodeConfigurationRequest.getter(UpdateKxClusterCodeConfigurationRequest::clientToken)).setter(UpdateKxClusterCodeConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<CodeConfiguration> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("code").getter(UpdateKxClusterCodeConfigurationRequest.getter(UpdateKxClusterCodeConfigurationRequest::code)).setter(UpdateKxClusterCodeConfigurationRequest.setter(Builder::code)).constructor(CodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> INITIALIZATION_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initializationScript").getter(UpdateKxClusterCodeConfigurationRequest.getter(UpdateKxClusterCodeConfigurationRequest::initializationScript)).setter(UpdateKxClusterCodeConfigurationRequest.setter(Builder::initializationScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationScript").build()}).build();
    private static final SdkField<List<KxCommandLineArgument>> COMMAND_LINE_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("commandLineArguments").getter(UpdateKxClusterCodeConfigurationRequest.getter(UpdateKxClusterCodeConfigurationRequest::commandLineArguments)).setter(UpdateKxClusterCodeConfigurationRequest.setter(Builder::commandLineArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commandLineArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxCommandLineArgument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KxClusterCodeDeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentConfiguration").getter(UpdateKxClusterCodeConfigurationRequest.getter(UpdateKxClusterCodeConfigurationRequest::deploymentConfiguration)).setter(UpdateKxClusterCodeConfigurationRequest.setter(Builder::deploymentConfiguration)).constructor(KxClusterCodeDeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, CLUSTER_NAME_FIELD, CLIENT_TOKEN_FIELD, CODE_FIELD, INITIALIZATION_SCRIPT_FIELD, COMMAND_LINE_ARGUMENTS_FIELD, DEPLOYMENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("clusterName", CLUSTER_NAME_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("code", CODE_FIELD);
            this.put("initializationScript", INITIALIZATION_SCRIPT_FIELD);
            this.put("commandLineArguments", COMMAND_LINE_ARGUMENTS_FIELD);
            this.put("deploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
        }
    });
    private final String environmentId;
    private final String clusterName;
    private final String clientToken;
    private final CodeConfiguration code;
    private final String initializationScript;
    private final List<KxCommandLineArgument> commandLineArguments;
    private final KxClusterCodeDeploymentConfiguration deploymentConfiguration;

    private UpdateKxClusterCodeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.clusterName = builder.clusterName;
        this.clientToken = builder.clientToken;
        this.code = builder.code;
        this.initializationScript = builder.initializationScript;
        this.commandLineArguments = builder.commandLineArguments;
        this.deploymentConfiguration = builder.deploymentConfiguration;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final CodeConfiguration code() {
        return this.code;
    }

    public final String initializationScript() {
        return this.initializationScript;
    }

    public final boolean hasCommandLineArguments() {
        return this.commandLineArguments != null && !(this.commandLineArguments instanceof SdkAutoConstructList);
    }

    public final List<KxCommandLineArgument> commandLineArguments() {
        return this.commandLineArguments;
    }

    public final KxClusterCodeDeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommandLineArguments() ? this.commandLineArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxClusterCodeConfigurationRequest)) {
            return false;
        }
        UpdateKxClusterCodeConfigurationRequest other = (UpdateKxClusterCodeConfigurationRequest)((Object)obj);
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.initializationScript(), other.initializationScript()) && this.hasCommandLineArguments() == other.hasCommandLineArguments() && Objects.equals(this.commandLineArguments(), other.commandLineArguments()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateKxClusterCodeConfigurationRequest").add("EnvironmentId", (Object)this.environmentId()).add("ClusterName", (Object)this.clusterName()).add("ClientToken", (Object)this.clientToken()).add("Code", (Object)this.code()).add("InitializationScript", (Object)this.initializationScript()).add("CommandLineArguments", this.hasCommandLineArguments() ? this.commandLineArguments() : null).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "initializationScript": {
                return Optional.ofNullable(clazz.cast(this.initializationScript()));
            }
            case "commandLineArguments": {
                return Optional.ofNullable(clazz.cast(this.commandLineArguments()));
            }
            case "deploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxClusterCodeConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateKxClusterCodeConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceRequest.BuilderImpl
    implements Builder {
        private String environmentId;
        private String clusterName;
        private String clientToken;
        private CodeConfiguration code;
        private String initializationScript;
        private List<KxCommandLineArgument> commandLineArguments = DefaultSdkAutoConstructList.getInstance();
        private KxClusterCodeDeploymentConfiguration deploymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxClusterCodeConfigurationRequest model) {
            super(model);
            this.environmentId(model.environmentId);
            this.clusterName(model.clusterName);
            this.clientToken(model.clientToken);
            this.code(model.code);
            this.initializationScript(model.initializationScript);
            this.commandLineArguments(model.commandLineArguments);
            this.deploymentConfiguration(model.deploymentConfiguration);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CodeConfiguration.Builder getCode() {
            return this.code != null ? this.code.toBuilder() : null;
        }

        public final void setCode(CodeConfiguration.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(CodeConfiguration code) {
            this.code = code;
            return this;
        }

        public final String getInitializationScript() {
            return this.initializationScript;
        }

        public final void setInitializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
        }

        @Override
        public final Builder initializationScript(String initializationScript) {
            this.initializationScript = initializationScript;
            return this;
        }

        public final List<KxCommandLineArgument.Builder> getCommandLineArguments() {
            List<KxCommandLineArgument.Builder> result = KxCommandLineArgumentsCopier.copyToBuilder(this.commandLineArguments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommandLineArguments(Collection<KxCommandLineArgument.BuilderImpl> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copyFromBuilder(commandLineArguments);
        }

        @Override
        public final Builder commandLineArguments(Collection<KxCommandLineArgument> commandLineArguments) {
            this.commandLineArguments = KxCommandLineArgumentsCopier.copy(commandLineArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(KxCommandLineArgument ... commandLineArguments) {
            this.commandLineArguments(Arrays.asList(commandLineArguments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder> ... commandLineArguments) {
            this.commandLineArguments(Stream.of(commandLineArguments).map(c -> (KxCommandLineArgument)((KxCommandLineArgument.Builder)KxCommandLineArgument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KxClusterCodeDeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(KxClusterCodeDeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(KxClusterCodeDeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKxClusterCodeConfigurationRequest build() {
            return new UpdateKxClusterCodeConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateKxClusterCodeConfigurationRequest> {
        public Builder environmentId(String var1);

        public Builder clusterName(String var1);

        public Builder clientToken(String var1);

        public Builder code(CodeConfiguration var1);

        default public Builder code(Consumer<CodeConfiguration.Builder> code) {
            return this.code((CodeConfiguration)((CodeConfiguration.Builder)CodeConfiguration.builder().applyMutation(code)).build());
        }

        public Builder initializationScript(String var1);

        public Builder commandLineArguments(Collection<KxCommandLineArgument> var1);

        public Builder commandLineArguments(KxCommandLineArgument ... var1);

        public Builder commandLineArguments(Consumer<KxCommandLineArgument.Builder> ... var1);

        public Builder deploymentConfiguration(KxClusterCodeDeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<KxClusterCodeDeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((KxClusterCodeDeploymentConfiguration)((KxClusterCodeDeploymentConfiguration.Builder)KxClusterCodeDeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

