/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKxDatabaseResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, GetKxDatabaseResponse> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::databaseName)).setter(GetKxDatabaseResponse.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseArn").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::databaseArn)).setter(GetKxDatabaseResponse.setter(Builder::databaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::environmentId)).setter(GetKxDatabaseResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::description)).setter(GetKxDatabaseResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::createdTimestamp)).setter(GetKxDatabaseResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::lastModifiedTimestamp)).setter(GetKxDatabaseResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<String> LAST_COMPLETED_CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastCompletedChangesetId").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::lastCompletedChangesetId)).setter(GetKxDatabaseResponse.setter(Builder::lastCompletedChangesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCompletedChangesetId").build()}).build();
    private static final SdkField<Long> NUM_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numBytes").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::numBytes)).setter(GetKxDatabaseResponse.setter(Builder::numBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numBytes").build()}).build();
    private static final SdkField<Integer> NUM_CHANGESETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numChangesets").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::numChangesets)).setter(GetKxDatabaseResponse.setter(Builder::numChangesets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numChangesets").build()}).build();
    private static final SdkField<Integer> NUM_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numFiles").getter(GetKxDatabaseResponse.getter(GetKxDatabaseResponse::numFiles)).setter(GetKxDatabaseResponse.setter(Builder::numFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numFiles").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, DATABASE_ARN_FIELD, ENVIRONMENT_ID_FIELD, DESCRIPTION_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, LAST_COMPLETED_CHANGESET_ID_FIELD, NUM_BYTES_FIELD, NUM_CHANGESETS_FIELD, NUM_FILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("databaseName", DATABASE_NAME_FIELD);
            this.put("databaseArn", DATABASE_ARN_FIELD);
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
            this.put("lastCompletedChangesetId", LAST_COMPLETED_CHANGESET_ID_FIELD);
            this.put("numBytes", NUM_BYTES_FIELD);
            this.put("numChangesets", NUM_CHANGESETS_FIELD);
            this.put("numFiles", NUM_FILES_FIELD);
        }
    });
    private final String databaseName;
    private final String databaseArn;
    private final String environmentId;
    private final String description;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;
    private final String lastCompletedChangesetId;
    private final Long numBytes;
    private final Integer numChangesets;
    private final Integer numFiles;

    private GetKxDatabaseResponse(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.databaseArn = builder.databaseArn;
        this.environmentId = builder.environmentId;
        this.description = builder.description;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.lastCompletedChangesetId = builder.lastCompletedChangesetId;
        this.numBytes = builder.numBytes;
        this.numChangesets = builder.numChangesets;
        this.numFiles = builder.numFiles;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String databaseArn() {
        return this.databaseArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final String lastCompletedChangesetId() {
        return this.lastCompletedChangesetId;
    }

    public final Long numBytes() {
        return this.numBytes;
    }

    public final Integer numChangesets() {
        return this.numChangesets;
    }

    public final Integer numFiles() {
        return this.numFiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCompletedChangesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.numChangesets());
        hashCode = 31 * hashCode + Objects.hashCode(this.numFiles());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxDatabaseResponse)) {
            return false;
        }
        GetKxDatabaseResponse other = (GetKxDatabaseResponse)((Object)obj);
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.databaseArn(), other.databaseArn()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.lastCompletedChangesetId(), other.lastCompletedChangesetId()) && Objects.equals(this.numBytes(), other.numBytes()) && Objects.equals(this.numChangesets(), other.numChangesets()) && Objects.equals(this.numFiles(), other.numFiles());
    }

    public final String toString() {
        return ToString.builder((String)"GetKxDatabaseResponse").add("DatabaseName", (Object)this.databaseName()).add("DatabaseArn", (Object)this.databaseArn()).add("EnvironmentId", (Object)this.environmentId()).add("Description", (Object)this.description()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("LastCompletedChangesetId", (Object)this.lastCompletedChangesetId()).add("NumBytes", (Object)this.numBytes()).add("NumChangesets", (Object)this.numChangesets()).add("NumFiles", (Object)this.numFiles()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "databaseArn": {
                return Optional.ofNullable(clazz.cast(this.databaseArn()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "lastCompletedChangesetId": {
                return Optional.ofNullable(clazz.cast(this.lastCompletedChangesetId()));
            }
            case "numBytes": {
                return Optional.ofNullable(clazz.cast(this.numBytes()));
            }
            case "numChangesets": {
                return Optional.ofNullable(clazz.cast(this.numChangesets()));
            }
            case "numFiles": {
                return Optional.ofNullable(clazz.cast(this.numFiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetKxDatabaseResponse, T> g) {
        return obj -> g.apply((GetKxDatabaseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String databaseName;
        private String databaseArn;
        private String environmentId;
        private String description;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;
        private String lastCompletedChangesetId;
        private Long numBytes;
        private Integer numChangesets;
        private Integer numFiles;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxDatabaseResponse model) {
            super(model);
            this.databaseName(model.databaseName);
            this.databaseArn(model.databaseArn);
            this.environmentId(model.environmentId);
            this.description(model.description);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.lastCompletedChangesetId(model.lastCompletedChangesetId);
            this.numBytes(model.numBytes);
            this.numChangesets(model.numChangesets);
            this.numFiles(model.numFiles);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDatabaseArn() {
            return this.databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getLastCompletedChangesetId() {
            return this.lastCompletedChangesetId;
        }

        public final void setLastCompletedChangesetId(String lastCompletedChangesetId) {
            this.lastCompletedChangesetId = lastCompletedChangesetId;
        }

        @Override
        public final Builder lastCompletedChangesetId(String lastCompletedChangesetId) {
            this.lastCompletedChangesetId = lastCompletedChangesetId;
            return this;
        }

        public final Long getNumBytes() {
            return this.numBytes;
        }

        public final void setNumBytes(Long numBytes) {
            this.numBytes = numBytes;
        }

        @Override
        public final Builder numBytes(Long numBytes) {
            this.numBytes = numBytes;
            return this;
        }

        public final Integer getNumChangesets() {
            return this.numChangesets;
        }

        public final void setNumChangesets(Integer numChangesets) {
            this.numChangesets = numChangesets;
        }

        @Override
        public final Builder numChangesets(Integer numChangesets) {
            this.numChangesets = numChangesets;
            return this;
        }

        public final Integer getNumFiles() {
            return this.numFiles;
        }

        public final void setNumFiles(Integer numFiles) {
            this.numFiles = numFiles;
        }

        @Override
        public final Builder numFiles(Integer numFiles) {
            this.numFiles = numFiles;
            return this;
        }

        @Override
        public GetKxDatabaseResponse build() {
            return new GetKxDatabaseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKxDatabaseResponse> {
        public Builder databaseName(String var1);

        public Builder databaseArn(String var1);

        public Builder environmentId(String var1);

        public Builder description(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder lastCompletedChangesetId(String var1);

        public Builder numBytes(Long var1);

        public Builder numChangesets(Integer var1);

        public Builder numFiles(Integer var1);
    }
}

