/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.KxAzMode;
import software.amazon.awssdk.services.finspace.model.KxDataviewActiveVersion;
import software.amazon.awssdk.services.finspace.model.KxDataviewActiveVersionListCopier;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfigurationListCopier;
import software.amazon.awssdk.services.finspace.model.KxDataviewStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxDataviewListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxDataviewListEntry> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(KxDataviewListEntry.getter(KxDataviewListEntry::environmentId)).setter(KxDataviewListEntry.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(KxDataviewListEntry.getter(KxDataviewListEntry::databaseName)).setter(KxDataviewListEntry.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataviewName").getter(KxDataviewListEntry.getter(KxDataviewListEntry::dataviewName)).setter(KxDataviewListEntry.setter(Builder::dataviewName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()}).build();
    private static final SdkField<String> AZ_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("azMode").getter(KxDataviewListEntry.getter(KxDataviewListEntry::azModeAsString)).setter(KxDataviewListEntry.setter(Builder::azMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azMode").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(KxDataviewListEntry.getter(KxDataviewListEntry::availabilityZoneId)).setter(KxDataviewListEntry.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(KxDataviewListEntry.getter(KxDataviewListEntry::changesetId)).setter(KxDataviewListEntry.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("segmentConfigurations").getter(KxDataviewListEntry.getter(KxDataviewListEntry::segmentConfigurations)).setter(KxDataviewListEntry.setter(Builder::segmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDataviewSegmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KxDataviewActiveVersion>> ACTIVE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activeVersions").getter(KxDataviewListEntry.getter(KxDataviewListEntry::activeVersions)).setter(KxDataviewListEntry.setter(Builder::activeVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDataviewActiveVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(KxDataviewListEntry.getter(KxDataviewListEntry::statusAsString)).setter(KxDataviewListEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(KxDataviewListEntry.getter(KxDataviewListEntry::description)).setter(KxDataviewListEntry.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoUpdate").getter(KxDataviewListEntry.getter(KxDataviewListEntry::autoUpdate)).setter(KxDataviewListEntry.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoUpdate").build()}).build();
    private static final SdkField<Boolean> READ_WRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readWrite").getter(KxDataviewListEntry.getter(KxDataviewListEntry::readWrite)).setter(KxDataviewListEntry.setter(Builder::readWrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readWrite").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(KxDataviewListEntry.getter(KxDataviewListEntry::createdTimestamp)).setter(KxDataviewListEntry.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(KxDataviewListEntry.getter(KxDataviewListEntry::lastModifiedTimestamp)).setter(KxDataviewListEntry.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(KxDataviewListEntry.getter(KxDataviewListEntry::statusReason)).setter(KxDataviewListEntry.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD, DATABASE_NAME_FIELD, DATAVIEW_NAME_FIELD, AZ_MODE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CHANGESET_ID_FIELD, SEGMENT_CONFIGURATIONS_FIELD, ACTIVE_VERSIONS_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, AUTO_UPDATE_FIELD, READ_WRITE_FIELD, CREATED_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("databaseName", DATABASE_NAME_FIELD);
            this.put("dataviewName", DATAVIEW_NAME_FIELD);
            this.put("azMode", AZ_MODE_FIELD);
            this.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
            this.put("changesetId", CHANGESET_ID_FIELD);
            this.put("segmentConfigurations", SEGMENT_CONFIGURATIONS_FIELD);
            this.put("activeVersions", ACTIVE_VERSIONS_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("autoUpdate", AUTO_UPDATE_FIELD);
            this.put("readWrite", READ_WRITE_FIELD);
            this.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
            this.put("statusReason", STATUS_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String environmentId;
    private final String databaseName;
    private final String dataviewName;
    private final String azMode;
    private final String availabilityZoneId;
    private final String changesetId;
    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;
    private final List<KxDataviewActiveVersion> activeVersions;
    private final String status;
    private final String description;
    private final Boolean autoUpdate;
    private final Boolean readWrite;
    private final Instant createdTimestamp;
    private final Instant lastModifiedTimestamp;
    private final String statusReason;

    private KxDataviewListEntry(BuilderImpl builder) {
        this.environmentId = builder.environmentId;
        this.databaseName = builder.databaseName;
        this.dataviewName = builder.dataviewName;
        this.azMode = builder.azMode;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
        this.activeVersions = builder.activeVersions;
        this.status = builder.status;
        this.description = builder.description;
        this.autoUpdate = builder.autoUpdate;
        this.readWrite = builder.readWrite;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.statusReason = builder.statusReason;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dataviewName() {
        return this.dataviewName;
    }

    public final KxAzMode azMode() {
        return KxAzMode.fromValue(this.azMode);
    }

    public final String azModeAsString() {
        return this.azMode;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final boolean hasSegmentConfigurations() {
        return this.segmentConfigurations != null && !(this.segmentConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return this.segmentConfigurations;
    }

    public final boolean hasActiveVersions() {
        return this.activeVersions != null && !(this.activeVersions instanceof SdkAutoConstructList);
    }

    public final List<KxDataviewActiveVersion> activeVersions() {
        return this.activeVersions;
    }

    public final KxDataviewStatus status() {
        return KxDataviewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public final Boolean readWrite() {
        return this.readWrite;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(this.azModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentConfigurations() ? this.segmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveVersions() ? this.activeVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.readWrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDataviewListEntry)) {
            return false;
        }
        KxDataviewListEntry other = (KxDataviewListEntry)obj;
        return Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dataviewName(), other.dataviewName()) && Objects.equals(this.azModeAsString(), other.azModeAsString()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.changesetId(), other.changesetId()) && this.hasSegmentConfigurations() == other.hasSegmentConfigurations() && Objects.equals(this.segmentConfigurations(), other.segmentConfigurations()) && this.hasActiveVersions() == other.hasActiveVersions() && Objects.equals(this.activeVersions(), other.activeVersions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.autoUpdate(), other.autoUpdate()) && Objects.equals(this.readWrite(), other.readWrite()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"KxDataviewListEntry").add("EnvironmentId", (Object)this.environmentId()).add("DatabaseName", (Object)this.databaseName()).add("DataviewName", (Object)this.dataviewName()).add("AzMode", (Object)this.azModeAsString()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("ChangesetId", (Object)this.changesetId()).add("SegmentConfigurations", this.hasSegmentConfigurations() ? this.segmentConfigurations() : null).add("ActiveVersions", this.hasActiveVersions() ? this.activeVersions() : null).add("Status", (Object)this.statusAsString()).add("Description", (Object)this.description()).add("AutoUpdate", (Object)this.autoUpdate()).add("ReadWrite", (Object)this.readWrite()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "dataviewName": {
                return Optional.ofNullable(clazz.cast(this.dataviewName()));
            }
            case "azMode": {
                return Optional.ofNullable(clazz.cast(this.azModeAsString()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "segmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.segmentConfigurations()));
            }
            case "activeVersions": {
                return Optional.ofNullable(clazz.cast(this.activeVersions()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "autoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
            case "readWrite": {
                return Optional.ofNullable(clazz.cast(this.readWrite()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KxDataviewListEntry, T> g) {
        return obj -> g.apply((KxDataviewListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentId;
        private String databaseName;
        private String dataviewName;
        private String azMode;
        private String availabilityZoneId;
        private String changesetId;
        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<KxDataviewActiveVersion> activeVersions = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String description;
        private Boolean autoUpdate;
        private Boolean readWrite;
        private Instant createdTimestamp;
        private Instant lastModifiedTimestamp;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(KxDataviewListEntry model) {
            this.environmentId(model.environmentId);
            this.databaseName(model.databaseName);
            this.dataviewName(model.dataviewName);
            this.azMode(model.azMode);
            this.availabilityZoneId(model.availabilityZoneId);
            this.changesetId(model.changesetId);
            this.segmentConfigurations(model.segmentConfigurations);
            this.activeVersions(model.activeVersions);
            this.status(model.status);
            this.description(model.description);
            this.autoUpdate(model.autoUpdate);
            this.readWrite(model.readWrite);
            this.createdTimestamp(model.createdTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.statusReason(model.statusReason);
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDataviewName() {
            return this.dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final String getAzMode() {
            return this.azMode;
        }

        public final void setAzMode(String azMode) {
            this.azMode = azMode;
        }

        @Override
        public final Builder azMode(String azMode) {
            this.azMode = azMode;
            return this;
        }

        @Override
        public final Builder azMode(KxAzMode azMode) {
            this.azMode(azMode == null ? null : azMode.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier.copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration ... segmentConfigurations) {
            this.segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... segmentConfigurations) {
            this.segmentConfigurations(Stream.of(segmentConfigurations).map(c -> (KxDataviewSegmentConfiguration)((KxDataviewSegmentConfiguration.Builder)KxDataviewSegmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<KxDataviewActiveVersion.Builder> getActiveVersions() {
            List<KxDataviewActiveVersion.Builder> result = KxDataviewActiveVersionListCopier.copyToBuilder(this.activeVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveVersions(Collection<KxDataviewActiveVersion.BuilderImpl> activeVersions) {
            this.activeVersions = KxDataviewActiveVersionListCopier.copyFromBuilder(activeVersions);
        }

        @Override
        public final Builder activeVersions(Collection<KxDataviewActiveVersion> activeVersions) {
            this.activeVersions = KxDataviewActiveVersionListCopier.copy(activeVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeVersions(KxDataviewActiveVersion ... activeVersions) {
            this.activeVersions(Arrays.asList(activeVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeVersions(Consumer<KxDataviewActiveVersion.Builder> ... activeVersions) {
            this.activeVersions(Stream.of(activeVersions).map(c -> (KxDataviewActiveVersion)((KxDataviewActiveVersion.Builder)KxDataviewActiveVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(KxDataviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final Boolean getReadWrite() {
            return this.readWrite;
        }

        public final void setReadWrite(Boolean readWrite) {
            this.readWrite = readWrite;
        }

        @Override
        public final Builder readWrite(Boolean readWrite) {
            this.readWrite = readWrite;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public KxDataviewListEntry build() {
            return new KxDataviewListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxDataviewListEntry> {
        public Builder environmentId(String var1);

        public Builder databaseName(String var1);

        public Builder dataviewName(String var1);

        public Builder azMode(String var1);

        public Builder azMode(KxAzMode var1);

        public Builder availabilityZoneId(String var1);

        public Builder changesetId(String var1);

        public Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> var1);

        public Builder segmentConfigurations(KxDataviewSegmentConfiguration ... var1);

        public Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... var1);

        public Builder activeVersions(Collection<KxDataviewActiveVersion> var1);

        public Builder activeVersions(KxDataviewActiveVersion ... var1);

        public Builder activeVersions(Consumer<KxDataviewActiveVersion.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(KxDataviewStatus var1);

        public Builder description(String var1);

        public Builder autoUpdate(Boolean var1);

        public Builder readWrite(Boolean var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder statusReason(String var1);
    }
}

