/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.ChangeRequest;
import software.amazon.awssdk.services.finspace.model.ChangeRequestsCopier;
import software.amazon.awssdk.services.finspace.model.ChangesetStatus;
import software.amazon.awssdk.services.finspace.model.ErrorInfo;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKxChangesetResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, GetKxChangesetResponse> {
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::changesetId)).setter(GetKxChangesetResponse.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::databaseName)).setter(GetKxChangesetResponse.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::environmentId)).setter(GetKxChangesetResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<List<ChangeRequest>> CHANGE_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("changeRequests").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::changeRequests)).setter(GetKxChangesetResponse.setter(Builder::changeRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTimestamp").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::createdTimestamp)).setter(GetKxChangesetResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTimestamp").build()}).build();
    private static final SdkField<Instant> ACTIVE_FROM_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("activeFromTimestamp").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::activeFromTimestamp)).setter(GetKxChangesetResponse.setter(Builder::activeFromTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeFromTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedTimestamp").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::lastModifiedTimestamp)).setter(GetKxChangesetResponse.setter(Builder::lastModifiedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::statusAsString)).setter(GetKxChangesetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorInfo").getter(GetKxChangesetResponse.getter(GetKxChangesetResponse::errorInfo)).setter(GetKxChangesetResponse.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGESET_ID_FIELD, DATABASE_NAME_FIELD, ENVIRONMENT_ID_FIELD, CHANGE_REQUESTS_FIELD, CREATED_TIMESTAMP_FIELD, ACTIVE_FROM_TIMESTAMP_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD, STATUS_FIELD, ERROR_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("changesetId", CHANGESET_ID_FIELD);
            this.put("databaseName", DATABASE_NAME_FIELD);
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("changeRequests", CHANGE_REQUESTS_FIELD);
            this.put("createdTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("activeFromTimestamp", ACTIVE_FROM_TIMESTAMP_FIELD);
            this.put("lastModifiedTimestamp", LAST_MODIFIED_TIMESTAMP_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("errorInfo", ERROR_INFO_FIELD);
        }
    });
    private final String changesetId;
    private final String databaseName;
    private final String environmentId;
    private final List<ChangeRequest> changeRequests;
    private final Instant createdTimestamp;
    private final Instant activeFromTimestamp;
    private final Instant lastModifiedTimestamp;
    private final String status;
    private final ErrorInfo errorInfo;

    private GetKxChangesetResponse(BuilderImpl builder) {
        super(builder);
        this.changesetId = builder.changesetId;
        this.databaseName = builder.databaseName;
        this.environmentId = builder.environmentId;
        this.changeRequests = builder.changeRequests;
        this.createdTimestamp = builder.createdTimestamp;
        this.activeFromTimestamp = builder.activeFromTimestamp;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
        this.status = builder.status;
        this.errorInfo = builder.errorInfo;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final boolean hasChangeRequests() {
        return this.changeRequests != null && !(this.changeRequests instanceof SdkAutoConstructList);
    }

    public final List<ChangeRequest> changeRequests() {
        return this.changeRequests;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant activeFromTimestamp() {
        return this.activeFromTimestamp;
    }

    public final Instant lastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public final ChangesetStatus status() {
        return ChangesetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeRequests() ? this.changeRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeFromTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKxChangesetResponse)) {
            return false;
        }
        GetKxChangesetResponse other = (GetKxChangesetResponse)((Object)obj);
        return Objects.equals(this.changesetId(), other.changesetId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.environmentId(), other.environmentId()) && this.hasChangeRequests() == other.hasChangeRequests() && Objects.equals(this.changeRequests(), other.changeRequests()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.activeFromTimestamp(), other.activeFromTimestamp()) && Objects.equals(this.lastModifiedTimestamp(), other.lastModifiedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorInfo(), other.errorInfo());
    }

    public final String toString() {
        return ToString.builder((String)"GetKxChangesetResponse").add("ChangesetId", (Object)this.changesetId()).add("DatabaseName", (Object)this.databaseName()).add("EnvironmentId", (Object)this.environmentId()).add("ChangeRequests", this.hasChangeRequests() ? this.changeRequests() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("ActiveFromTimestamp", (Object)this.activeFromTimestamp()).add("LastModifiedTimestamp", (Object)this.lastModifiedTimestamp()).add("Status", (Object)this.statusAsString()).add("ErrorInfo", (Object)this.errorInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "changeRequests": {
                return Optional.ofNullable(clazz.cast(this.changeRequests()));
            }
            case "createdTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "activeFromTimestamp": {
                return Optional.ofNullable(clazz.cast(this.activeFromTimestamp()));
            }
            case "lastModifiedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetKxChangesetResponse, T> g) {
        return obj -> g.apply((GetKxChangesetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private String changesetId;
        private String databaseName;
        private String environmentId;
        private List<ChangeRequest> changeRequests = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;
        private Instant activeFromTimestamp;
        private Instant lastModifiedTimestamp;
        private String status;
        private ErrorInfo errorInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKxChangesetResponse model) {
            super(model);
            this.changesetId(model.changesetId);
            this.databaseName(model.databaseName);
            this.environmentId(model.environmentId);
            this.changeRequests(model.changeRequests);
            this.createdTimestamp(model.createdTimestamp);
            this.activeFromTimestamp(model.activeFromTimestamp);
            this.lastModifiedTimestamp(model.lastModifiedTimestamp);
            this.status(model.status);
            this.errorInfo(model.errorInfo);
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final List<ChangeRequest.Builder> getChangeRequests() {
            List<ChangeRequest.Builder> result = ChangeRequestsCopier.copyToBuilder(this.changeRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeRequests(Collection<ChangeRequest.BuilderImpl> changeRequests) {
            this.changeRequests = ChangeRequestsCopier.copyFromBuilder(changeRequests);
        }

        @Override
        public final Builder changeRequests(Collection<ChangeRequest> changeRequests) {
            this.changeRequests = ChangeRequestsCopier.copy(changeRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRequests(ChangeRequest ... changeRequests) {
            this.changeRequests(Arrays.asList(changeRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeRequests(Consumer<ChangeRequest.Builder> ... changeRequests) {
            this.changeRequests(Stream.of(changeRequests).map(c -> (ChangeRequest)((ChangeRequest.Builder)ChangeRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getActiveFromTimestamp() {
            return this.activeFromTimestamp;
        }

        public final void setActiveFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
        }

        @Override
        public final Builder activeFromTimestamp(Instant activeFromTimestamp) {
            this.activeFromTimestamp = activeFromTimestamp;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return this.lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangesetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        @Override
        public GetKxChangesetResponse build() {
            return new GetKxChangesetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKxChangesetResponse> {
        public Builder changesetId(String var1);

        public Builder databaseName(String var1);

        public Builder environmentId(String var1);

        public Builder changeRequests(Collection<ChangeRequest> var1);

        public Builder changeRequests(ChangeRequest ... var1);

        public Builder changeRequests(Consumer<ChangeRequest.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);

        public Builder activeFromTimestamp(Instant var1);

        public Builder lastModifiedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(ChangesetStatus var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }
    }
}

