/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesRequest;
import software.amazon.awssdk.services.finspace.model.ListKxDatabasesResponse;

public class ListKxDatabasesIterable
implements SdkIterable<ListKxDatabasesResponse> {
    private final FinspaceClient client;
    private final ListKxDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKxDatabasesIterable(FinspaceClient client, ListKxDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKxDatabasesResponseFetcher();
    }

    public Iterator<ListKxDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListKxDatabasesResponseFetcher
    implements SyncPageFetcher<ListKxDatabasesResponse> {
        private ListKxDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(ListKxDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKxDatabasesResponse nextPage(ListKxDatabasesResponse previousPage) {
            if (previousPage == null) {
                return ListKxDatabasesIterable.this.client.listKxDatabases(ListKxDatabasesIterable.this.firstRequest);
            }
            return ListKxDatabasesIterable.this.client.listKxDatabases((ListKxDatabasesRequest)((Object)ListKxDatabasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

