/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsRequest;
import software.amazon.awssdk.services.finspace.model.ListKxScalingGroupsResponse;

public class ListKxScalingGroupsIterable
implements SdkIterable<ListKxScalingGroupsResponse> {
    private final FinspaceClient client;
    private final ListKxScalingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKxScalingGroupsIterable(FinspaceClient client, ListKxScalingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKxScalingGroupsResponseFetcher();
    }

    public Iterator<ListKxScalingGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListKxScalingGroupsResponseFetcher
    implements SyncPageFetcher<ListKxScalingGroupsResponse> {
        private ListKxScalingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListKxScalingGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKxScalingGroupsResponse nextPage(ListKxScalingGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListKxScalingGroupsIterable.this.client.listKxScalingGroups(ListKxScalingGroupsIterable.this.firstRequest);
            }
            return ListKxScalingGroupsIterable.this.client.listKxScalingGroups((ListKxScalingGroupsRequest)((Object)ListKxScalingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

