/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.FinspaceResponse;
import software.amazon.awssdk.services.finspace.model.KxVolume;
import software.amazon.awssdk.services.finspace.model.KxVolumesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKxVolumesResponse
extends FinspaceResponse
implements ToCopyableBuilder<Builder, ListKxVolumesResponse> {
    private static final SdkField<List<KxVolume>> KX_VOLUME_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("kxVolumeSummaries").getter(ListKxVolumesResponse.getter(ListKxVolumesResponse::kxVolumeSummaries)).setter(ListKxVolumesResponse.setter(Builder::kxVolumeSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kxVolumeSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListKxVolumesResponse.getter(ListKxVolumesResponse::nextToken)).setter(ListKxVolumesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KX_VOLUME_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<KxVolume> kxVolumeSummaries;
    private final String nextToken;

    private ListKxVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.kxVolumeSummaries = builder.kxVolumeSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasKxVolumeSummaries() {
        return this.kxVolumeSummaries != null && !(this.kxVolumeSummaries instanceof SdkAutoConstructList);
    }

    public final List<KxVolume> kxVolumeSummaries() {
        return this.kxVolumeSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKxVolumeSummaries() ? this.kxVolumeSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxVolumesResponse)) {
            return false;
        }
        ListKxVolumesResponse other = (ListKxVolumesResponse)((Object)obj);
        return this.hasKxVolumeSummaries() == other.hasKxVolumeSummaries() && Objects.equals(this.kxVolumeSummaries(), other.kxVolumeSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListKxVolumesResponse").add("KxVolumeSummaries", this.hasKxVolumeSummaries() ? this.kxVolumeSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kxVolumeSummaries": {
                return Optional.ofNullable(clazz.cast(this.kxVolumeSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKxVolumesResponse, T> g) {
        return obj -> g.apply((ListKxVolumesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FinspaceResponse.BuilderImpl
    implements Builder {
        private List<KxVolume> kxVolumeSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxVolumesResponse model) {
            super(model);
            this.kxVolumeSummaries(model.kxVolumeSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<KxVolume.Builder> getKxVolumeSummaries() {
            List<KxVolume.Builder> result = KxVolumesCopier.copyToBuilder(this.kxVolumeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKxVolumeSummaries(Collection<KxVolume.BuilderImpl> kxVolumeSummaries) {
            this.kxVolumeSummaries = KxVolumesCopier.copyFromBuilder(kxVolumeSummaries);
        }

        @Override
        public final Builder kxVolumeSummaries(Collection<KxVolume> kxVolumeSummaries) {
            this.kxVolumeSummaries = KxVolumesCopier.copy(kxVolumeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxVolumeSummaries(KxVolume ... kxVolumeSummaries) {
            this.kxVolumeSummaries(Arrays.asList(kxVolumeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder kxVolumeSummaries(Consumer<KxVolume.Builder> ... kxVolumeSummaries) {
            this.kxVolumeSummaries(Stream.of(kxVolumeSummaries).map(c -> (KxVolume)((KxVolume.Builder)KxVolume.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKxVolumesResponse build() {
            return new ListKxVolumesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FinspaceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKxVolumesResponse> {
        public Builder kxVolumeSummaries(Collection<KxVolume> var1);

        public Builder kxVolumeSummaries(KxVolume ... var1);

        public Builder kxVolumeSummaries(Consumer<KxVolume.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

