/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.DbPathsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxDatabaseCacheConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxDatabaseCacheConfiguration> {
    private static final SdkField<String> CACHE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheType").getter(KxDatabaseCacheConfiguration.getter(KxDatabaseCacheConfiguration::cacheType)).setter(KxDatabaseCacheConfiguration.setter(Builder::cacheType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheType").build()}).build();
    private static final SdkField<List<String>> DB_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbPaths").getter(KxDatabaseCacheConfiguration.getter(KxDatabaseCacheConfiguration::dbPaths)).setter(KxDatabaseCacheConfiguration.setter(Builder::dbPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataviewName").getter(KxDatabaseCacheConfiguration.getter(KxDatabaseCacheConfiguration::dataviewName)).setter(KxDatabaseCacheConfiguration.setter(Builder::dataviewName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_TYPE_FIELD, DB_PATHS_FIELD, DATAVIEW_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String cacheType;
    private final List<String> dbPaths;
    private final String dataviewName;

    private KxDatabaseCacheConfiguration(BuilderImpl builder) {
        this.cacheType = builder.cacheType;
        this.dbPaths = builder.dbPaths;
        this.dataviewName = builder.dataviewName;
    }

    public final String cacheType() {
        return this.cacheType;
    }

    public final boolean hasDbPaths() {
        return this.dbPaths != null && !(this.dbPaths instanceof SdkAutoConstructList);
    }

    public final List<String> dbPaths() {
        return this.dbPaths;
    }

    public final String dataviewName() {
        return this.dataviewName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbPaths() ? this.dbPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataviewName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDatabaseCacheConfiguration)) {
            return false;
        }
        KxDatabaseCacheConfiguration other = (KxDatabaseCacheConfiguration)obj;
        return Objects.equals(this.cacheType(), other.cacheType()) && this.hasDbPaths() == other.hasDbPaths() && Objects.equals(this.dbPaths(), other.dbPaths()) && Objects.equals(this.dataviewName(), other.dataviewName());
    }

    public final String toString() {
        return ToString.builder((String)"KxDatabaseCacheConfiguration").add("CacheType", (Object)this.cacheType()).add("DbPaths", this.hasDbPaths() ? this.dbPaths() : null).add("DataviewName", (Object)this.dataviewName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cacheType": {
                return Optional.ofNullable(clazz.cast(this.cacheType()));
            }
            case "dbPaths": {
                return Optional.ofNullable(clazz.cast(this.dbPaths()));
            }
            case "dataviewName": {
                return Optional.ofNullable(clazz.cast(this.dataviewName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxDatabaseCacheConfiguration, T> g) {
        return obj -> g.apply((KxDatabaseCacheConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cacheType;
        private List<String> dbPaths = DefaultSdkAutoConstructList.getInstance();
        private String dataviewName;

        private BuilderImpl() {
        }

        private BuilderImpl(KxDatabaseCacheConfiguration model) {
            this.cacheType(model.cacheType);
            this.dbPaths(model.dbPaths);
            this.dataviewName(model.dataviewName);
        }

        public final String getCacheType() {
            return this.cacheType;
        }

        public final void setCacheType(String cacheType) {
            this.cacheType = cacheType;
        }

        @Override
        public final Builder cacheType(String cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public final Collection<String> getDbPaths() {
            if (this.dbPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbPaths;
        }

        public final void setDbPaths(Collection<String> dbPaths) {
            this.dbPaths = DbPathsCopier.copy(dbPaths);
        }

        @Override
        public final Builder dbPaths(Collection<String> dbPaths) {
            this.dbPaths = DbPathsCopier.copy(dbPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbPaths(String ... dbPaths) {
            this.dbPaths(Arrays.asList(dbPaths));
            return this;
        }

        public final String getDataviewName() {
            return this.dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public KxDatabaseCacheConfiguration build() {
            return new KxDatabaseCacheConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxDatabaseCacheConfiguration> {
        public Builder cacheType(String var1);

        public Builder dbPaths(Collection<String> var1);

        public Builder dbPaths(String ... var1);

        public Builder dataviewName(String var1);
    }
}

