/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfiguration;
import software.amazon.awssdk.services.finspace.model.KxDataviewSegmentConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KxDataviewConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KxDataviewConfiguration> {
    private static final SdkField<String> DATAVIEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataviewName").getter(KxDataviewConfiguration.getter(KxDataviewConfiguration::dataviewName)).setter(KxDataviewConfiguration.setter(Builder::dataviewName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewName").build()}).build();
    private static final SdkField<String> DATAVIEW_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataviewVersionId").getter(KxDataviewConfiguration.getter(KxDataviewConfiguration::dataviewVersionId)).setter(KxDataviewConfiguration.setter(Builder::dataviewVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataviewVersionId").build()}).build();
    private static final SdkField<String> CHANGESET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changesetId").getter(KxDataviewConfiguration.getter(KxDataviewConfiguration::changesetId)).setter(KxDataviewConfiguration.setter(Builder::changesetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changesetId").build()}).build();
    private static final SdkField<List<KxDataviewSegmentConfiguration>> SEGMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("segmentConfigurations").getter(KxDataviewConfiguration.getter(KxDataviewConfiguration::segmentConfigurations)).setter(KxDataviewConfiguration.setter(Builder::segmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KxDataviewSegmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATAVIEW_NAME_FIELD, DATAVIEW_VERSION_ID_FIELD, CHANGESET_ID_FIELD, SEGMENT_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataviewName;
    private final String dataviewVersionId;
    private final String changesetId;
    private final List<KxDataviewSegmentConfiguration> segmentConfigurations;

    private KxDataviewConfiguration(BuilderImpl builder) {
        this.dataviewName = builder.dataviewName;
        this.dataviewVersionId = builder.dataviewVersionId;
        this.changesetId = builder.changesetId;
        this.segmentConfigurations = builder.segmentConfigurations;
    }

    public final String dataviewName() {
        return this.dataviewName;
    }

    public final String dataviewVersionId() {
        return this.dataviewVersionId;
    }

    public final String changesetId() {
        return this.changesetId;
    }

    public final boolean hasSegmentConfigurations() {
        return this.segmentConfigurations != null && !(this.segmentConfigurations instanceof SdkAutoConstructList);
    }

    public final List<KxDataviewSegmentConfiguration> segmentConfigurations() {
        return this.segmentConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataviewName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataviewVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changesetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentConfigurations() ? this.segmentConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KxDataviewConfiguration)) {
            return false;
        }
        KxDataviewConfiguration other = (KxDataviewConfiguration)obj;
        return Objects.equals(this.dataviewName(), other.dataviewName()) && Objects.equals(this.dataviewVersionId(), other.dataviewVersionId()) && Objects.equals(this.changesetId(), other.changesetId()) && this.hasSegmentConfigurations() == other.hasSegmentConfigurations() && Objects.equals(this.segmentConfigurations(), other.segmentConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"KxDataviewConfiguration").add("DataviewName", (Object)this.dataviewName()).add("DataviewVersionId", (Object)this.dataviewVersionId()).add("ChangesetId", (Object)this.changesetId()).add("SegmentConfigurations", this.hasSegmentConfigurations() ? this.segmentConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataviewName": {
                return Optional.ofNullable(clazz.cast(this.dataviewName()));
            }
            case "dataviewVersionId": {
                return Optional.ofNullable(clazz.cast(this.dataviewVersionId()));
            }
            case "changesetId": {
                return Optional.ofNullable(clazz.cast(this.changesetId()));
            }
            case "segmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.segmentConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KxDataviewConfiguration, T> g) {
        return obj -> g.apply((KxDataviewConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataviewName;
        private String dataviewVersionId;
        private String changesetId;
        private List<KxDataviewSegmentConfiguration> segmentConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KxDataviewConfiguration model) {
            this.dataviewName(model.dataviewName);
            this.dataviewVersionId(model.dataviewVersionId);
            this.changesetId(model.changesetId);
            this.segmentConfigurations(model.segmentConfigurations);
        }

        public final String getDataviewName() {
            return this.dataviewName;
        }

        public final void setDataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
        }

        @Override
        public final Builder dataviewName(String dataviewName) {
            this.dataviewName = dataviewName;
            return this;
        }

        public final String getDataviewVersionId() {
            return this.dataviewVersionId;
        }

        public final void setDataviewVersionId(String dataviewVersionId) {
            this.dataviewVersionId = dataviewVersionId;
        }

        @Override
        public final Builder dataviewVersionId(String dataviewVersionId) {
            this.dataviewVersionId = dataviewVersionId;
            return this;
        }

        public final String getChangesetId() {
            return this.changesetId;
        }

        public final void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        @Override
        public final Builder changesetId(String changesetId) {
            this.changesetId = changesetId;
            return this;
        }

        public final List<KxDataviewSegmentConfiguration.Builder> getSegmentConfigurations() {
            List<KxDataviewSegmentConfiguration.Builder> result = KxDataviewSegmentConfigurationListCopier.copyToBuilder(this.segmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentConfigurations(Collection<KxDataviewSegmentConfiguration.BuilderImpl> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copyFromBuilder(segmentConfigurations);
        }

        @Override
        public final Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> segmentConfigurations) {
            this.segmentConfigurations = KxDataviewSegmentConfigurationListCopier.copy(segmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(KxDataviewSegmentConfiguration ... segmentConfigurations) {
            this.segmentConfigurations(Arrays.asList(segmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... segmentConfigurations) {
            this.segmentConfigurations(Stream.of(segmentConfigurations).map(c -> (KxDataviewSegmentConfiguration)((KxDataviewSegmentConfiguration.Builder)KxDataviewSegmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public KxDataviewConfiguration build() {
            return new KxDataviewConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KxDataviewConfiguration> {
        public Builder dataviewName(String var1);

        public Builder dataviewVersionId(String var1);

        public Builder changesetId(String var1);

        public Builder segmentConfigurations(Collection<KxDataviewSegmentConfiguration> var1);

        public Builder segmentConfigurations(KxDataviewSegmentConfiguration ... var1);

        public Builder segmentConfigurations(Consumer<KxDataviewSegmentConfiguration.Builder> ... var1);
    }
}

