/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.finspace.DefaultFinspaceBaseClientBuilder;
import software.amazon.awssdk.services.finspace.DefaultFinspaceClient;
import software.amazon.awssdk.services.finspace.FinspaceClient;
import software.amazon.awssdk.services.finspace.FinspaceClientBuilder;
import software.amazon.awssdk.services.finspace.FinspaceServiceClientConfiguration;
import software.amazon.awssdk.services.finspace.endpoints.FinspaceEndpointProvider;

@SdkInternalApi
final class DefaultFinspaceClientBuilder
extends DefaultFinspaceBaseClientBuilder<FinspaceClientBuilder, FinspaceClient>
implements FinspaceClientBuilder {
    DefaultFinspaceClientBuilder() {
    }

    @Override
    public DefaultFinspaceClientBuilder endpointProvider(FinspaceEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final FinspaceClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultFinspaceClientBuilder.validateClientOptions(clientConfiguration);
        FinspaceServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultFinspaceClient client = new DefaultFinspaceClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private FinspaceServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return FinspaceServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

