/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKxDatabaseResponse extends FinspaceResponse implements
        ToCopyableBuilder<UpdateKxDatabaseResponse.Builder, UpdateKxDatabaseResponse> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(UpdateKxDatabaseResponse::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(UpdateKxDatabaseResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateKxDatabaseResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTimestamp").getter(getter(UpdateKxDatabaseResponse::lastModifiedTimestamp))
            .setter(setter(Builder::lastModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            ENVIRONMENT_ID_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_TIMESTAMP_FIELD));

    private final String databaseName;

    private final String environmentId;

    private final String description;

    private final Instant lastModifiedTimestamp;

    private UpdateKxDatabaseResponse(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.environmentId = builder.environmentId;
        this.description = builder.description;
        this.lastModifiedTimestamp = builder.lastModifiedTimestamp;
    }

    /**
     * <p>
     * The name of the kdb database.
     * </p>
     * 
     * @return The name of the kdb database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment.
     * </p>
     * 
     * @return A unique identifier for the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * A description of the database.
     * </p>
     * 
     * @return A description of the database.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The last time that the database was modified. The value is determined as epoch time in milliseconds. For example,
     * the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     * </p>
     * 
     * @return The last time that the database was modified. The value is determined as epoch time in milliseconds. For
     *         example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
     */
    public final Instant lastModifiedTimestamp() {
        return lastModifiedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxDatabaseResponse)) {
            return false;
        }
        UpdateKxDatabaseResponse other = (UpdateKxDatabaseResponse) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(description(), other.description())
                && Objects.equals(lastModifiedTimestamp(), other.lastModifiedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKxDatabaseResponse").add("DatabaseName", databaseName())
                .add("EnvironmentId", environmentId()).add("Description", description())
                .add("LastModifiedTimestamp", lastModifiedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(lastModifiedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKxDatabaseResponse, T> g) {
        return obj -> g.apply((UpdateKxDatabaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKxDatabaseResponse> {
        /**
         * <p>
         * The name of the kdb database.
         * </p>
         * 
         * @param databaseName
         *        The name of the kdb database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A unique identifier for the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * A description of the database.
         * </p>
         * 
         * @param description
         *        A description of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The last time that the database was modified. The value is determined as epoch time in milliseconds. For
         * example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * </p>
         * 
         * @param lastModifiedTimestamp
         *        The last time that the database was modified. The value is determined as epoch time in milliseconds.
         *        For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimestamp(Instant lastModifiedTimestamp);
    }

    static final class BuilderImpl extends FinspaceResponse.BuilderImpl implements Builder {
        private String databaseName;

        private String environmentId;

        private String description;

        private Instant lastModifiedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKxDatabaseResponse model) {
            super(model);
            databaseName(model.databaseName);
            environmentId(model.environmentId);
            description(model.description);
            lastModifiedTimestamp(model.lastModifiedTimestamp);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedTimestamp() {
            return lastModifiedTimestamp;
        }

        public final void setLastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
        }

        @Override
        public final Builder lastModifiedTimestamp(Instant lastModifiedTimestamp) {
            this.lastModifiedTimestamp = lastModifiedTimestamp;
            return this;
        }

        @Override
        public UpdateKxDatabaseResponse build() {
            return new UpdateKxDatabaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
