/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.finspace.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKxClustersRequest extends FinspaceRequest implements
        ToCopyableBuilder<ListKxClustersRequest.Builder, ListKxClustersRequest> {
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(ListKxClustersRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentId").build()).build();

    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterType").getter(getter(ListKxClustersRequest::clusterTypeAsString))
            .setter(setter(Builder::clusterType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clusterType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListKxClustersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListKxClustersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_ID_FIELD,
            CLUSTER_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String environmentId;

    private final String clusterType;

    private final Integer maxResults;

    private final String nextToken;

    private ListKxClustersRequest(BuilderImpl builder) {
        super(builder);
        this.environmentId = builder.environmentId;
        this.clusterType = builder.clusterType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the kdb environment.
     * </p>
     * 
     * @return A unique identifier for the kdb environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Specifies the type of KDB database that is being created. The following types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
     * managed kdb databases mounted to the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
     * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster
     * type requires local storage for temporary storage of data during the savedown process. If you specify this field
     * in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create
     * your own routing logic using the initialization scripts and custom code. This type of cluster does not require a
     * writable local storage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of KDB database that is being created. The following types are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
     *         FinSpace managed kdb databases mounted to the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it
     *         in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
     *         cluster type requires local storage for temporary storage of data during the savedown process. If you
     *         specify this field in your request, you must provide the <code>savedownStorageConfiguration</code>
     *         parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
     *         create your own routing logic using the initialization scripts and custom code. This type of cluster does
     *         not require a writable local storage.
     *         </p>
     *         </li>
     * @see KxClusterType
     */
    public final KxClusterType clusterType() {
        return KxClusterType.fromValue(clusterType);
    }

    /**
     * <p>
     * Specifies the type of KDB database that is being created. The following types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
     * managed kdb databases mounted to the cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
     * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster
     * type requires local storage for temporary storage of data during the savedown process. If you specify this field
     * in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create
     * your own routing logic using the initialization scripts and custom code. This type of cluster does not require a
     * writable local storage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterType} will
     * return {@link KxClusterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of KDB database that is being created. The following types are available: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
     *         FinSpace managed kdb databases mounted to the cluster.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it
     *         in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
     *         cluster type requires local storage for temporary storage of data during the savedown process. If you
     *         specify this field in your request, you must provide the <code>savedownStorageConfiguration</code>
     *         parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
     *         create your own routing logic using the initialization scripts and custom code. This type of cluster does
     *         not require a writable local storage.
     *         </p>
     *         </li>
     * @see KxClusterType
     */
    public final String clusterTypeAsString() {
        return clusterType;
    }

    /**
     * <p>
     * The maximum number of results to return in this request.
     * </p>
     * 
     * @return The maximum number of results to return in this request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that indicates where a results page should begin.
     * </p>
     * 
     * @return A token that indicates where a results page should begin.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKxClustersRequest)) {
            return false;
        }
        ListKxClustersRequest other = (ListKxClustersRequest) obj;
        return Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(clusterTypeAsString(), other.clusterTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKxClustersRequest").add("EnvironmentId", environmentId())
                .add("ClusterType", clusterTypeAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "clusterType":
            return Optional.ofNullable(clazz.cast(clusterTypeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKxClustersRequest, T> g) {
        return obj -> g.apply((ListKxClustersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FinspaceRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListKxClustersRequest> {
        /**
         * <p>
         * A unique identifier for the kdb environment.
         * </p>
         * 
         * @param environmentId
         *        A unique identifier for the kdb environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Specifies the type of KDB database that is being created. The following types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
         * managed kdb databases mounted to the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
         * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
         * cluster type requires local storage for temporary storage of data during the savedown process. If you specify
         * this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
         * create your own routing logic using the initialization scripts and custom code. This type of cluster does not
         * require a writable local storage.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterType
         *        Specifies the type of KDB database that is being created. The following types are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
         *        FinSpace managed kdb databases mounted to the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores
         *        it in memory until the end of day, after which it writes all of its data to a disk and reloads the
         *        HDB. This cluster type requires local storage for temporary storage of data during the savedown
         *        process. If you specify this field in your request, you must provide the
         *        <code>savedownStorageConfiguration</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you
         *        to create your own routing logic using the initialization scripts and custom code. This type of
         *        cluster does not require a writable local storage.
         *        </p>
         *        </li>
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(String clusterType);

        /**
         * <p>
         * Specifies the type of KDB database that is being created. The following types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace
         * managed kdb databases mounted to the cluster.
         * </p>
         * </li>
         * <li>
         * <p>
         * RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in
         * memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This
         * cluster type requires local storage for temporary storage of data during the savedown process. If you specify
         * this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to
         * create your own routing logic using the initialization scripts and custom code. This type of cluster does not
         * require a writable local storage.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterType
         *        Specifies the type of KDB database that is being created. The following types are available: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        HDB – A Historical Database. The data is only accessible with read-only permissions from one of the
         *        FinSpace managed kdb databases mounted to the cluster.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores
         *        it in memory until the end of day, after which it writes all of its data to a disk and reloads the
         *        HDB. This cluster type requires local storage for temporary storage of data during the savedown
         *        process. If you specify this field in your request, you must provide the
         *        <code>savedownStorageConfiguration</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you
         *        to create your own routing logic using the initialization scripts and custom code. This type of
         *        cluster does not require a writable local storage.
         *        </p>
         *        </li>
         * @see KxClusterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KxClusterType
         */
        Builder clusterType(KxClusterType clusterType);

        /**
         * <p>
         * The maximum number of results to return in this request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that indicates where a results page should begin.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates where a results page should begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FinspaceRequest.BuilderImpl implements Builder {
        private String environmentId;

        private String clusterType;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKxClustersRequest model) {
            super(model);
            environmentId(model.environmentId);
            clusterType(model.clusterType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getClusterType() {
            return clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(KxClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListKxClustersRequest build() {
            return new ListKxClustersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
