/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Elastic VMware Service (Amazon EVS) is a service that you can use to deploy a VMware Cloud Foundation (VCF)
 * software environment directly on EC2 bare metal instances within an Amazon Virtual Private Cloud (VPC).
 * </p>
 * <p>
 * Workloads running on Amazon EVS are fully compatible with workloads running on any standard VMware vSphere
 * environment. This means that you can migrate any VMware-based workload to Amazon EVS without workload modification.
 * </p>
 */
package software.amazon.awssdk.services.evs;