/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentsRequest extends EvsRequest implements
        ToCopyableBuilder<ListEnvironmentsRequest.Builder, ListEnvironmentsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnvironmentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> STATE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("state")
            .getter(getter(ListEnvironmentsRequest::stateAsStrings))
            .setter(setter(Builder::stateWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> state;

    private ListEnvironmentsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.state = builder.state;
    }

    /**
     * <p>
     * A unique pagination token for each page. If <code>nextToken</code> is returned, there are more results available.
     * Make the call again using the returned token with all other arguments unchanged to retrieve the next page. Each
     * pagination token expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400
     * InvalidToken</i> error.
     * </p>
     * 
     * @return A unique pagination token for each page. If <code>nextToken</code> is returned, there are more results
     *         available. Make the call again using the returned token with all other arguments unchanged to retrieve
     *         the next page. Each pagination token expires after 24 hours. Using an expired pagination token will
     *         return an <i>HTTP 400 InvalidToken</i> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return. If you specify <code>MaxResults</code> in the request, the response
     * includes information up to the limit specified.
     * </p>
     * 
     * @return The maximum number of results to return. If you specify <code>MaxResults</code> in the request, the
     *         response includes information up to the limit specified.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The state of an environment. Used to filter response results to return only environments with the specified
     * <code>environmentState</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasState} method.
     * </p>
     * 
     * @return The state of an environment. Used to filter response results to return only environments with the
     *         specified <code>environmentState</code>.
     */
    public final List<EnvironmentState> state() {
        return EnvironmentStateListCopier.copyStringToEnum(state);
    }

    /**
     * For responses, this returns true if the service returned a value for the State property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasState() {
        return state != null && !(state instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The state of an environment. Used to filter response results to return only environments with the specified
     * <code>environmentState</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasState} method.
     * </p>
     * 
     * @return The state of an environment. Used to filter response results to return only environments with the
     *         specified <code>environmentState</code>.
     */
    public final List<String> stateAsStrings() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasState() ? stateAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentsRequest)) {
            return false;
        }
        ListEnvironmentsRequest other = (ListEnvironmentsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasState() == other.hasState() && Objects.equals(stateAsStrings(), other.stateAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("State", hasState() ? stateAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentsRequest, T> g) {
        return obj -> g.apply((ListEnvironmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EvsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListEnvironmentsRequest> {
        /**
         * <p>
         * A unique pagination token for each page. If <code>nextToken</code> is returned, there are more results
         * available. Make the call again using the returned token with all other arguments unchanged to retrieve the
         * next page. Each pagination token expires after 24 hours. Using an expired pagination token will return an
         * <i>HTTP 400 InvalidToken</i> error.
         * </p>
         * 
         * @param nextToken
         *        A unique pagination token for each page. If <code>nextToken</code> is returned, there are more results
         *        available. Make the call again using the returned token with all other arguments unchanged to retrieve
         *        the next page. Each pagination token expires after 24 hours. Using an expired pagination token will
         *        return an <i>HTTP 400 InvalidToken</i> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return. If you specify <code>MaxResults</code> in the request, the response
         * includes information up to the limit specified.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return. If you specify <code>MaxResults</code> in the request, the
         *        response includes information up to the limit specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The state of an environment. Used to filter response results to return only environments with the specified
         * <code>environmentState</code>.
         * </p>
         * 
         * @param state
         *        The state of an environment. Used to filter response results to return only environments with the
         *        specified <code>environmentState</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateWithStrings(Collection<String> state);

        /**
         * <p>
         * The state of an environment. Used to filter response results to return only environments with the specified
         * <code>environmentState</code>.
         * </p>
         * 
         * @param state
         *        The state of an environment. Used to filter response results to return only environments with the
         *        specified <code>environmentState</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateWithStrings(String... state);

        /**
         * <p>
         * The state of an environment. Used to filter response results to return only environments with the specified
         * <code>environmentState</code>.
         * </p>
         * 
         * @param state
         *        The state of an environment. Used to filter response results to return only environments with the
         *        specified <code>environmentState</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(Collection<EnvironmentState> state);

        /**
         * <p>
         * The state of an environment. Used to filter response results to return only environments with the specified
         * <code>environmentState</code>.
         * </p>
         * 
         * @param state
         *        The state of an environment. Used to filter response results to return only environments with the
         *        specified <code>environmentState</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(EnvironmentState... state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<String> state = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            stateWithStrings(model.state);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getState() {
            if (state instanceof SdkAutoConstructList) {
                return null;
            }
            return state;
        }

        public final void setState(Collection<String> state) {
            this.state = EnvironmentStateListCopier.copy(state);
        }

        @Override
        public final Builder stateWithStrings(Collection<String> state) {
            this.state = EnvironmentStateListCopier.copy(state);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateWithStrings(String... state) {
            stateWithStrings(Arrays.asList(state));
            return this;
        }

        @Override
        public final Builder state(Collection<EnvironmentState> state) {
            this.state = EnvironmentStateListCopier.copyEnumToString(state);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder state(EnvironmentState... state) {
            state(Arrays.asList(state));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentsRequest build() {
            return new ListEnvironmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
