/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evs.EvsAsyncClient;
import software.amazon.awssdk.services.evs.internal.UserAgentUtils;
import software.amazon.awssdk.services.evs.model.ListEnvironmentVlansRequest;
import software.amazon.awssdk.services.evs.model.ListEnvironmentVlansResponse;
import software.amazon.awssdk.services.evs.model.Vlan;

public class ListEnvironmentVlansPublisher
implements SdkPublisher<ListEnvironmentVlansResponse> {
    private final EvsAsyncClient client;
    private final ListEnvironmentVlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentVlansPublisher(EvsAsyncClient client, ListEnvironmentVlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentVlansPublisher(EvsAsyncClient client, ListEnvironmentVlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentVlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentVlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Vlan> environmentVlans() {
        Function<ListEnvironmentVlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.environmentVlans() != null) {
                return response.environmentVlans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentVlansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentVlansResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentVlansResponse> {
        private ListEnvironmentVlansResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentVlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentVlansResponse> nextPage(ListEnvironmentVlansResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentVlansPublisher.this.client.listEnvironmentVlans(ListEnvironmentVlansPublisher.this.firstRequest);
            }
            return ListEnvironmentVlansPublisher.this.client.listEnvironmentVlans((ListEnvironmentVlansRequest)((Object)ListEnvironmentVlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

