/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseInfo> {
    private static final SdkField<String> SOLUTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("solutionKey").getter(LicenseInfo.getter(LicenseInfo::solutionKey)).setter(LicenseInfo.setter(Builder::solutionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("solutionKey").build()}).build();
    private static final SdkField<String> VSAN_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vsanKey").getter(LicenseInfo.getter(LicenseInfo::vsanKey)).setter(LicenseInfo.setter(Builder::vsanKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vsanKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_KEY_FIELD, VSAN_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String solutionKey;
    private final String vsanKey;

    private LicenseInfo(BuilderImpl builder) {
        this.solutionKey = builder.solutionKey;
        this.vsanKey = builder.vsanKey;
    }

    public final String solutionKey() {
        return this.solutionKey;
    }

    public final String vsanKey() {
        return this.vsanKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.vsanKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseInfo)) {
            return false;
        }
        LicenseInfo other = (LicenseInfo)obj;
        return Objects.equals(this.solutionKey(), other.solutionKey()) && Objects.equals(this.vsanKey(), other.vsanKey());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseInfo").add("SolutionKey", (Object)this.solutionKey()).add("VsanKey", (Object)this.vsanKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "solutionKey": {
                return Optional.ofNullable(clazz.cast(this.solutionKey()));
            }
            case "vsanKey": {
                return Optional.ofNullable(clazz.cast(this.vsanKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("solutionKey", SOLUTION_KEY_FIELD);
        map.put("vsanKey", VSAN_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseInfo, T> g) {
        return obj -> g.apply((LicenseInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String solutionKey;
        private String vsanKey;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseInfo model) {
            this.solutionKey(model.solutionKey);
            this.vsanKey(model.vsanKey);
        }

        public final String getSolutionKey() {
            return this.solutionKey;
        }

        public final void setSolutionKey(String solutionKey) {
            this.solutionKey = solutionKey;
        }

        @Override
        public final Builder solutionKey(String solutionKey) {
            this.solutionKey = solutionKey;
            return this;
        }

        public final String getVsanKey() {
            return this.vsanKey;
        }

        public final void setVsanKey(String vsanKey) {
            this.vsanKey = vsanKey;
        }

        @Override
        public final Builder vsanKey(String vsanKey) {
            this.vsanKey = vsanKey;
            return this;
        }

        public LicenseInfo build() {
            return new LicenseInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseInfo> {
        public Builder solutionKey(String var1);

        public Builder vsanKey(String var1);
    }
}

