/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evs.model.HostState;
import software.amazon.awssdk.services.evs.model.InstanceType;
import software.amazon.awssdk.services.evs.model.NetworkInterface;
import software.amazon.awssdk.services.evs.model.NetworkInterfaceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Host
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Host> {
    private static final SdkField<String> HOST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostName").getter(Host.getter(Host::hostName)).setter(Host.setter(Builder::hostName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddress").getter(Host.getter(Host::ipAddress)).setter(Host.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyName").getter(Host.getter(Host::keyName)).setter(Host.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(Host.getter(Host::instanceTypeAsString)).setter(Host.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("placementGroupId").getter(Host.getter(Host::placementGroupId)).setter(Host.setter(Builder::placementGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementGroupId").build()}).build();
    private static final SdkField<String> DEDICATED_HOST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dedicatedHostId").getter(Host.getter(Host::dedicatedHostId)).setter(Host.setter(Builder::dedicatedHostId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedHostId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Host.getter(Host::createdAt)).setter(Host.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modifiedAt").getter(Host.getter(Host::modifiedAt)).setter(Host.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedAt").build()}).build();
    private static final SdkField<String> HOST_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostState").getter(Host.getter(Host::hostStateAsString)).setter(Host.setter(Builder::hostState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostState").build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(Host.getter(Host::stateDetails)).setter(Host.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2InstanceId").getter(Host.getter(Host::ec2InstanceId)).setter(Host.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceId").build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfaces").getter(Host.getter(Host::networkInterfaces)).setter(Host.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_NAME_FIELD, IP_ADDRESS_FIELD, KEY_NAME_FIELD, INSTANCE_TYPE_FIELD, PLACEMENT_GROUP_ID_FIELD, DEDICATED_HOST_ID_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, HOST_STATE_FIELD, STATE_DETAILS_FIELD, EC2_INSTANCE_ID_FIELD, NETWORK_INTERFACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Host.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostName;
    private final String ipAddress;
    private final String keyName;
    private final String instanceType;
    private final String placementGroupId;
    private final String dedicatedHostId;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final String hostState;
    private final String stateDetails;
    private final String ec2InstanceId;
    private final List<NetworkInterface> networkInterfaces;

    private Host(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.ipAddress = builder.ipAddress;
        this.keyName = builder.keyName;
        this.instanceType = builder.instanceType;
        this.placementGroupId = builder.placementGroupId;
        this.dedicatedHostId = builder.dedicatedHostId;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.hostState = builder.hostState;
        this.stateDetails = builder.stateDetails;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.networkInterfaces = builder.networkInterfaces;
    }

    public final String hostName() {
        return this.hostName;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String placementGroupId() {
        return this.placementGroupId;
    }

    public final String dedicatedHostId() {
        return this.dedicatedHostId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final HostState hostState() {
        return HostState.fromValue(this.hostState);
    }

    public final String hostStateAsString() {
        return this.hostState;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfaces() {
        return this.networkInterfaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedHostId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return Objects.equals(this.hostName(), other.hostName()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.placementGroupId(), other.placementGroupId()) && Objects.equals(this.dedicatedHostId(), other.dedicatedHostId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && Objects.equals(this.hostStateAsString(), other.hostStateAsString()) && Objects.equals(this.stateDetails(), other.stateDetails()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces());
    }

    public final String toString() {
        return ToString.builder((String)"Host").add("HostName", (Object)this.hostName()).add("IpAddress", (Object)this.ipAddress()).add("KeyName", (Object)this.keyName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("PlacementGroupId", (Object)this.placementGroupId()).add("DedicatedHostId", (Object)this.dedicatedHostId()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("HostState", (Object)this.hostStateAsString()).add("StateDetails", (Object)this.stateDetails()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostName": {
                return Optional.ofNullable(clazz.cast(this.hostName()));
            }
            case "ipAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "keyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "placementGroupId": {
                return Optional.ofNullable(clazz.cast(this.placementGroupId()));
            }
            case "dedicatedHostId": {
                return Optional.ofNullable(clazz.cast(this.dedicatedHostId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "modifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "hostState": {
                return Optional.ofNullable(clazz.cast(this.hostStateAsString()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "networkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hostName", HOST_NAME_FIELD);
        map.put("ipAddress", IP_ADDRESS_FIELD);
        map.put("keyName", KEY_NAME_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("placementGroupId", PLACEMENT_GROUP_ID_FIELD);
        map.put("dedicatedHostId", DEDICATED_HOST_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("modifiedAt", MODIFIED_AT_FIELD);
        map.put("hostState", HOST_STATE_FIELD);
        map.put("stateDetails", STATE_DETAILS_FIELD);
        map.put("ec2InstanceId", EC2_INSTANCE_ID_FIELD);
        map.put("networkInterfaces", NETWORK_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String ipAddress;
        private String keyName;
        private String instanceType;
        private String placementGroupId;
        private String dedicatedHostId;
        private Instant createdAt;
        private Instant modifiedAt;
        private String hostState;
        private String stateDetails;
        private String ec2InstanceId;
        private List<NetworkInterface> networkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            this.hostName(model.hostName);
            this.ipAddress(model.ipAddress);
            this.keyName(model.keyName);
            this.instanceType(model.instanceType);
            this.placementGroupId(model.placementGroupId);
            this.dedicatedHostId(model.dedicatedHostId);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.hostState(model.hostState);
            this.stateDetails(model.stateDetails);
            this.ec2InstanceId(model.ec2InstanceId);
            this.networkInterfaces(model.networkInterfaces);
        }

        public final String getHostName() {
            return this.hostName;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getPlacementGroupId() {
            return this.placementGroupId;
        }

        public final void setPlacementGroupId(String placementGroupId) {
            this.placementGroupId = placementGroupId;
        }

        @Override
        public final Builder placementGroupId(String placementGroupId) {
            this.placementGroupId = placementGroupId;
            return this;
        }

        public final String getDedicatedHostId() {
            return this.dedicatedHostId;
        }

        public final void setDedicatedHostId(String dedicatedHostId) {
            this.dedicatedHostId = dedicatedHostId;
        }

        @Override
        public final Builder dedicatedHostId(String dedicatedHostId) {
            this.dedicatedHostId = dedicatedHostId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final String getHostState() {
            return this.hostState;
        }

        public final void setHostState(String hostState) {
            this.hostState = hostState;
        }

        @Override
        public final Builder hostState(String hostState) {
            this.hostState = hostState;
            return this;
        }

        @Override
        public final Builder hostState(HostState hostState) {
            this.hostState(hostState == null ? null : hostState.toString());
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfaces() {
            List<NetworkInterface.Builder> result = NetworkInterfaceListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<NetworkInterface.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<NetworkInterface> networkInterfaces) {
            this.networkInterfaces = NetworkInterfaceListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Host build() {
            return new Host(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Host> {
        public Builder hostName(String var1);

        public Builder ipAddress(String var1);

        public Builder keyName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder placementGroupId(String var1);

        public Builder dedicatedHostId(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder hostState(String var1);

        public Builder hostState(HostState var1);

        public Builder stateDetails(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder networkInterfaces(Collection<NetworkInterface> var1);

        public Builder networkInterfaces(NetworkInterface ... var1);

        public Builder networkInterfaces(Consumer<NetworkInterface.Builder> ... var1);
    }
}

