/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evs.model.EnvironmentSummary;
import software.amazon.awssdk.services.evs.model.EvsResponse;
import software.amazon.awssdk.services.evs.model.Host;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentHostResponse
extends EvsResponse
implements ToCopyableBuilder<Builder, CreateEnvironmentHostResponse> {
    private static final SdkField<EnvironmentSummary> ENVIRONMENT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environmentSummary").getter(CreateEnvironmentHostResponse.getter(CreateEnvironmentHostResponse::environmentSummary)).setter(CreateEnvironmentHostResponse.setter(Builder::environmentSummary)).constructor(EnvironmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentSummary").build()}).build();
    private static final SdkField<Host> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("host").getter(CreateEnvironmentHostResponse.getter(CreateEnvironmentHostResponse::host)).setter(CreateEnvironmentHostResponse.setter(Builder::host)).constructor(Host::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_SUMMARY_FIELD, HOST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEnvironmentHostResponse.memberNameToFieldInitializer();
    private final EnvironmentSummary environmentSummary;
    private final Host host;

    private CreateEnvironmentHostResponse(BuilderImpl builder) {
        super(builder);
        this.environmentSummary = builder.environmentSummary;
        this.host = builder.host;
    }

    public final EnvironmentSummary environmentSummary() {
        return this.environmentSummary;
    }

    public final Host host() {
        return this.host;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentHostResponse)) {
            return false;
        }
        CreateEnvironmentHostResponse other = (CreateEnvironmentHostResponse)((Object)obj);
        return Objects.equals(this.environmentSummary(), other.environmentSummary()) && Objects.equals(this.host(), other.host());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentHostResponse").add("EnvironmentSummary", (Object)this.environmentSummary()).add("Host", (Object)this.host()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentSummary": {
                return Optional.ofNullable(clazz.cast(this.environmentSummary()));
            }
            case "host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentSummary", ENVIRONMENT_SUMMARY_FIELD);
        map.put("host", HOST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentHostResponse, T> g) {
        return obj -> g.apply((CreateEnvironmentHostResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvsResponse.BuilderImpl
    implements Builder {
        private EnvironmentSummary environmentSummary;
        private Host host;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentHostResponse model) {
            super(model);
            this.environmentSummary(model.environmentSummary);
            this.host(model.host);
        }

        public final EnvironmentSummary.Builder getEnvironmentSummary() {
            return this.environmentSummary != null ? this.environmentSummary.toBuilder() : null;
        }

        public final void setEnvironmentSummary(EnvironmentSummary.BuilderImpl environmentSummary) {
            this.environmentSummary = environmentSummary != null ? environmentSummary.build() : null;
        }

        @Override
        public final Builder environmentSummary(EnvironmentSummary environmentSummary) {
            this.environmentSummary = environmentSummary;
            return this;
        }

        public final Host.Builder getHost() {
            return this.host != null ? this.host.toBuilder() : null;
        }

        public final void setHost(Host.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        @Override
        public final Builder host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public CreateEnvironmentHostResponse build() {
            return new CreateEnvironmentHostResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentHostResponse> {
        public Builder environmentSummary(EnvironmentSummary var1);

        default public Builder environmentSummary(Consumer<EnvironmentSummary.Builder> environmentSummary) {
            return this.environmentSummary((EnvironmentSummary)((EnvironmentSummary.Builder)EnvironmentSummary.builder().applyMutation(environmentSummary)).build());
        }

        public Builder host(Host var1);

        default public Builder host(Consumer<Host.Builder> host) {
            return this.host((Host)((Host.Builder)Host.builder().applyMutation(host)).build());
        }
    }
}

