/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evs.model.EvsRequest;
import software.amazon.awssdk.services.evs.model.HostInfoForCreate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEnvironmentHostRequest
extends EvsRequest
implements ToCopyableBuilder<Builder, CreateEnvironmentHostRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateEnvironmentHostRequest.getter(CreateEnvironmentHostRequest::clientToken)).setter(CreateEnvironmentHostRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(CreateEnvironmentHostRequest.getter(CreateEnvironmentHostRequest::environmentId)).setter(CreateEnvironmentHostRequest.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<HostInfoForCreate> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("host").getter(CreateEnvironmentHostRequest.getter(CreateEnvironmentHostRequest::host)).setter(CreateEnvironmentHostRequest.setter(Builder::host)).constructor(HostInfoForCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("host").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ENVIRONMENT_ID_FIELD, HOST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEnvironmentHostRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String environmentId;
    private final HostInfoForCreate host;

    private CreateEnvironmentHostRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.environmentId = builder.environmentId;
        this.host = builder.host;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final HostInfoForCreate host() {
        return this.host;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentHostRequest)) {
            return false;
        }
        CreateEnvironmentHostRequest other = (CreateEnvironmentHostRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.host(), other.host());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEnvironmentHostRequest").add("ClientToken", (Object)this.clientToken()).add("EnvironmentId", (Object)this.environmentId()).add("Host", (Object)this.host()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("host", HOST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentHostRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentHostRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String environmentId;
        private HostInfoForCreate host;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentHostRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.environmentId(model.environmentId);
            this.host(model.host);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final HostInfoForCreate.Builder getHost() {
            return this.host != null ? this.host.toBuilder() : null;
        }

        public final void setHost(HostInfoForCreate.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        @Override
        public final Builder host(HostInfoForCreate host) {
            this.host = host;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentHostRequest build() {
            return new CreateEnvironmentHostRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEnvironmentHostRequest> {
        public Builder clientToken(String var1);

        public Builder environmentId(String var1);

        public Builder host(HostInfoForCreate var1);

        default public Builder host(Consumer<HostInfoForCreate.Builder> host) {
            return this.host((HostInfoForCreate)((HostInfoForCreate.Builder)HostInfoForCreate.builder().applyMutation(host)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

