/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.evidently.model.CloudWatchLogsDestinationConfig;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.S3DestinationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProjectDataDeliveryRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, UpdateProjectDataDeliveryRequest> {
    private static final SdkField<CloudWatchLogsDestinationConfig> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(UpdateProjectDataDeliveryRequest.getter(UpdateProjectDataDeliveryRequest::cloudWatchLogs)).setter(UpdateProjectDataDeliveryRequest.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsDestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(UpdateProjectDataDeliveryRequest.getter(UpdateProjectDataDeliveryRequest::project)).setter(UpdateProjectDataDeliveryRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final SdkField<S3DestinationConfig> S3_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Destination").getter(UpdateProjectDataDeliveryRequest.getter(UpdateProjectDataDeliveryRequest::s3Destination)).setter(UpdateProjectDataDeliveryRequest.setter(Builder::s3Destination)).constructor(S3DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD, PROJECT_FIELD, S3_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProjectDataDeliveryRequest.memberNameToFieldInitializer();
    private final CloudWatchLogsDestinationConfig cloudWatchLogs;
    private final String project;
    private final S3DestinationConfig s3Destination;

    private UpdateProjectDataDeliveryRequest(BuilderImpl builder) {
        super(builder);
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.project = builder.project;
        this.s3Destination = builder.s3Destination;
    }

    public final CloudWatchLogsDestinationConfig cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public final String project() {
        return this.project;
    }

    public final S3DestinationConfig s3Destination() {
        return this.s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectDataDeliveryRequest)) {
            return false;
        }
        UpdateProjectDataDeliveryRequest other = (UpdateProjectDataDeliveryRequest)((Object)obj);
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.s3Destination(), other.s3Destination());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProjectDataDeliveryRequest").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).add("Project", (Object)this.project()).add("S3Destination", (Object)this.s3Destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "s3Destination": {
                return Optional.ofNullable(clazz.cast(this.s3Destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("s3Destination", S3_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectDataDeliveryRequest, T> g) {
        return obj -> g.apply((UpdateProjectDataDeliveryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private CloudWatchLogsDestinationConfig cloudWatchLogs;
        private String project;
        private S3DestinationConfig s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectDataDeliveryRequest model) {
            super(model);
            this.cloudWatchLogs(model.cloudWatchLogs);
            this.project(model.project);
            this.s3Destination(model.s3Destination);
        }

        public final CloudWatchLogsDestinationConfig.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsDestinationConfig.BuilderImpl cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsDestinationConfig cloudWatchLogs) {
            this.cloudWatchLogs = cloudWatchLogs;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final S3DestinationConfig.Builder getS3Destination() {
            return this.s3Destination != null ? this.s3Destination.toBuilder() : null;
        }

        public final void setS3Destination(S3DestinationConfig.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public final Builder s3Destination(S3DestinationConfig s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectDataDeliveryRequest build() {
            return new UpdateProjectDataDeliveryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProjectDataDeliveryRequest> {
        public Builder cloudWatchLogs(CloudWatchLogsDestinationConfig var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsDestinationConfig.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsDestinationConfig)((CloudWatchLogsDestinationConfig.Builder)CloudWatchLogsDestinationConfig.builder().applyMutation(cloudWatchLogs)).build());
        }

        public Builder project(String var1);

        public Builder s3Destination(S3DestinationConfig var1);

        default public Builder s3Destination(Consumer<S3DestinationConfig.Builder> s3Destination) {
            return this.s3Destination((S3DestinationConfig)((S3DestinationConfig.Builder)S3DestinationConfig.builder().applyMutation(s3Destination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

