/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.MetricGoalConfig;
import software.amazon.awssdk.services.evidently.model.MetricGoalConfigListCopier;
import software.amazon.awssdk.services.evidently.model.OnlineAbConfig;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.services.evidently.model.TreatmentConfig;
import software.amazon.awssdk.services.evidently.model.TreatmentConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExperimentRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, CreateExperimentRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateExperimentRequest.getter(CreateExperimentRequest::description)).setter(CreateExperimentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<MetricGoalConfig>> METRIC_GOALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricGoals").getter(CreateExperimentRequest.getter(CreateExperimentRequest::metricGoals)).setter(CreateExperimentRequest.setter(Builder::metricGoals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricGoals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricGoalConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateExperimentRequest.getter(CreateExperimentRequest::name)).setter(CreateExperimentRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<OnlineAbConfig> ONLINE_AB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onlineAbConfig").getter(CreateExperimentRequest.getter(CreateExperimentRequest::onlineAbConfig)).setter(CreateExperimentRequest.setter(Builder::onlineAbConfig)).constructor(OnlineAbConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineAbConfig").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(CreateExperimentRequest.getter(CreateExperimentRequest::project)).setter(CreateExperimentRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final SdkField<String> RANDOMIZATION_SALT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("randomizationSalt").getter(CreateExperimentRequest.getter(CreateExperimentRequest::randomizationSalt)).setter(CreateExperimentRequest.setter(Builder::randomizationSalt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomizationSalt").build()}).build();
    private static final SdkField<Long> SAMPLING_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("samplingRate").getter(CreateExperimentRequest.getter(CreateExperimentRequest::samplingRate)).setter(CreateExperimentRequest.setter(Builder::samplingRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samplingRate").build()}).build();
    private static final SdkField<String> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("segment").getter(CreateExperimentRequest.getter(CreateExperimentRequest::segment)).setter(CreateExperimentRequest.setter(Builder::segment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segment").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateExperimentRequest.getter(CreateExperimentRequest::tags)).setter(CreateExperimentRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<TreatmentConfig>> TREATMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("treatments").getter(CreateExperimentRequest.getter(CreateExperimentRequest::treatments)).setter(CreateExperimentRequest.setter(Builder::treatments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TreatmentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, METRIC_GOALS_FIELD, NAME_FIELD, ONLINE_AB_CONFIG_FIELD, PROJECT_FIELD, RANDOMIZATION_SALT_FIELD, SAMPLING_RATE_FIELD, SEGMENT_FIELD, TAGS_FIELD, TREATMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExperimentRequest.memberNameToFieldInitializer();
    private final String description;
    private final List<MetricGoalConfig> metricGoals;
    private final String name;
    private final OnlineAbConfig onlineAbConfig;
    private final String project;
    private final String randomizationSalt;
    private final Long samplingRate;
    private final String segment;
    private final Map<String, String> tags;
    private final List<TreatmentConfig> treatments;

    private CreateExperimentRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.metricGoals = builder.metricGoals;
        this.name = builder.name;
        this.onlineAbConfig = builder.onlineAbConfig;
        this.project = builder.project;
        this.randomizationSalt = builder.randomizationSalt;
        this.samplingRate = builder.samplingRate;
        this.segment = builder.segment;
        this.tags = builder.tags;
        this.treatments = builder.treatments;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMetricGoals() {
        return this.metricGoals != null && !(this.metricGoals instanceof SdkAutoConstructList);
    }

    public final List<MetricGoalConfig> metricGoals() {
        return this.metricGoals;
    }

    public final String name() {
        return this.name;
    }

    public final OnlineAbConfig onlineAbConfig() {
        return this.onlineAbConfig;
    }

    public final String project() {
        return this.project;
    }

    public final String randomizationSalt() {
        return this.randomizationSalt;
    }

    public final Long samplingRate() {
        return this.samplingRate;
    }

    public final String segment() {
        return this.segment;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasTreatments() {
        return this.treatments != null && !(this.treatments instanceof SdkAutoConstructList);
    }

    public final List<TreatmentConfig> treatments() {
        return this.treatments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricGoals() ? this.metricGoals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineAbConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomizationSalt());
        hashCode = 31 * hashCode + Objects.hashCode(this.samplingRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTreatments() ? this.treatments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExperimentRequest)) {
            return false;
        }
        CreateExperimentRequest other = (CreateExperimentRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasMetricGoals() == other.hasMetricGoals() && Objects.equals(this.metricGoals(), other.metricGoals()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.onlineAbConfig(), other.onlineAbConfig()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.randomizationSalt(), other.randomizationSalt()) && Objects.equals(this.samplingRate(), other.samplingRate()) && Objects.equals(this.segment(), other.segment()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTreatments() == other.hasTreatments() && Objects.equals(this.treatments(), other.treatments());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExperimentRequest").add("Description", (Object)this.description()).add("MetricGoals", this.hasMetricGoals() ? this.metricGoals() : null).add("Name", (Object)this.name()).add("OnlineAbConfig", (Object)this.onlineAbConfig()).add("Project", (Object)this.project()).add("RandomizationSalt", (Object)this.randomizationSalt()).add("SamplingRate", (Object)this.samplingRate()).add("Segment", (Object)this.segment()).add("Tags", this.hasTags() ? this.tags() : null).add("Treatments", this.hasTreatments() ? this.treatments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "metricGoals": {
                return Optional.ofNullable(clazz.cast(this.metricGoals()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "onlineAbConfig": {
                return Optional.ofNullable(clazz.cast(this.onlineAbConfig()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "randomizationSalt": {
                return Optional.ofNullable(clazz.cast(this.randomizationSalt()));
            }
            case "samplingRate": {
                return Optional.ofNullable(clazz.cast(this.samplingRate()));
            }
            case "segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "treatments": {
                return Optional.ofNullable(clazz.cast(this.treatments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("metricGoals", METRIC_GOALS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("onlineAbConfig", ONLINE_AB_CONFIG_FIELD);
        map.put("project", PROJECT_FIELD);
        map.put("randomizationSalt", RANDOMIZATION_SALT_FIELD);
        map.put("samplingRate", SAMPLING_RATE_FIELD);
        map.put("segment", SEGMENT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("treatments", TREATMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExperimentRequest, T> g) {
        return obj -> g.apply((CreateExperimentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<MetricGoalConfig> metricGoals = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private OnlineAbConfig onlineAbConfig;
        private String project;
        private String randomizationSalt;
        private Long samplingRate;
        private String segment;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<TreatmentConfig> treatments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExperimentRequest model) {
            super(model);
            this.description(model.description);
            this.metricGoals(model.metricGoals);
            this.name(model.name);
            this.onlineAbConfig(model.onlineAbConfig);
            this.project(model.project);
            this.randomizationSalt(model.randomizationSalt);
            this.samplingRate(model.samplingRate);
            this.segment(model.segment);
            this.tags(model.tags);
            this.treatments(model.treatments);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<MetricGoalConfig.Builder> getMetricGoals() {
            List<MetricGoalConfig.Builder> result = MetricGoalConfigListCopier.copyToBuilder(this.metricGoals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricGoals(Collection<MetricGoalConfig.BuilderImpl> metricGoals) {
            this.metricGoals = MetricGoalConfigListCopier.copyFromBuilder(metricGoals);
        }

        @Override
        public final Builder metricGoals(Collection<MetricGoalConfig> metricGoals) {
            this.metricGoals = MetricGoalConfigListCopier.copy(metricGoals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(MetricGoalConfig ... metricGoals) {
            this.metricGoals(Arrays.asList(metricGoals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGoals(Consumer<MetricGoalConfig.Builder> ... metricGoals) {
            this.metricGoals(Stream.of(metricGoals).map(c -> (MetricGoalConfig)((MetricGoalConfig.Builder)MetricGoalConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final OnlineAbConfig.Builder getOnlineAbConfig() {
            return this.onlineAbConfig != null ? this.onlineAbConfig.toBuilder() : null;
        }

        public final void setOnlineAbConfig(OnlineAbConfig.BuilderImpl onlineAbConfig) {
            this.onlineAbConfig = onlineAbConfig != null ? onlineAbConfig.build() : null;
        }

        @Override
        public final Builder onlineAbConfig(OnlineAbConfig onlineAbConfig) {
            this.onlineAbConfig = onlineAbConfig;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getRandomizationSalt() {
            return this.randomizationSalt;
        }

        public final void setRandomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
        }

        @Override
        public final Builder randomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        public final Long getSamplingRate() {
            return this.samplingRate;
        }

        public final void setSamplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public final Builder samplingRate(Long samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        public final String getSegment() {
            return this.segment;
        }

        public final void setSegment(String segment) {
            this.segment = segment;
        }

        @Override
        public final Builder segment(String segment) {
            this.segment = segment;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<TreatmentConfig.Builder> getTreatments() {
            List<TreatmentConfig.Builder> result = TreatmentConfigListCopier.copyToBuilder(this.treatments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTreatments(Collection<TreatmentConfig.BuilderImpl> treatments) {
            this.treatments = TreatmentConfigListCopier.copyFromBuilder(treatments);
        }

        @Override
        public final Builder treatments(Collection<TreatmentConfig> treatments) {
            this.treatments = TreatmentConfigListCopier.copy(treatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(TreatmentConfig ... treatments) {
            this.treatments(Arrays.asList(treatments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatments(Consumer<TreatmentConfig.Builder> ... treatments) {
            this.treatments(Stream.of(treatments).map(c -> (TreatmentConfig)((TreatmentConfig.Builder)TreatmentConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExperimentRequest build() {
            return new CreateExperimentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExperimentRequest> {
        public Builder description(String var1);

        public Builder metricGoals(Collection<MetricGoalConfig> var1);

        public Builder metricGoals(MetricGoalConfig ... var1);

        public Builder metricGoals(Consumer<MetricGoalConfig.Builder> ... var1);

        public Builder name(String var1);

        public Builder onlineAbConfig(OnlineAbConfig var1);

        default public Builder onlineAbConfig(Consumer<OnlineAbConfig.Builder> onlineAbConfig) {
            return this.onlineAbConfig((OnlineAbConfig)((OnlineAbConfig.Builder)OnlineAbConfig.builder().applyMutation(onlineAbConfig)).build());
        }

        public Builder project(String var1);

        public Builder randomizationSalt(String var1);

        public Builder samplingRate(Long var1);

        public Builder segment(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder treatments(Collection<TreatmentConfig> var1);

        public Builder treatments(TreatmentConfig ... var1);

        public Builder treatments(Consumer<TreatmentConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

