/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvidentlyResponse;
import software.amazon.awssdk.services.evidently.model.RefResource;
import software.amazon.awssdk.services.evidently.model.RefResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSegmentReferencesResponse
extends EvidentlyResponse
implements ToCopyableBuilder<Builder, ListSegmentReferencesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSegmentReferencesResponse.getter(ListSegmentReferencesResponse::nextToken)).setter(ListSegmentReferencesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<RefResource>> REFERENCED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referencedBy").getter(ListSegmentReferencesResponse.getter(ListSegmentReferencesResponse::referencedBy)).setter(ListSegmentReferencesResponse.setter(Builder::referencedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referencedBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RefResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REFERENCED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSegmentReferencesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RefResource> referencedBy;

    private ListSegmentReferencesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.referencedBy = builder.referencedBy;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReferencedBy() {
        return this.referencedBy != null && !(this.referencedBy instanceof SdkAutoConstructList);
    }

    public final List<RefResource> referencedBy() {
        return this.referencedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferencedBy() ? this.referencedBy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSegmentReferencesResponse)) {
            return false;
        }
        ListSegmentReferencesResponse other = (ListSegmentReferencesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReferencedBy() == other.hasReferencedBy() && Objects.equals(this.referencedBy(), other.referencedBy());
    }

    public final String toString() {
        return ToString.builder((String)"ListSegmentReferencesResponse").add("NextToken", (Object)this.nextToken()).add("ReferencedBy", this.hasReferencedBy() ? this.referencedBy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "referencedBy": {
                return Optional.ofNullable(clazz.cast(this.referencedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("referencedBy", REFERENCED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSegmentReferencesResponse, T> g) {
        return obj -> g.apply((ListSegmentReferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RefResource> referencedBy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSegmentReferencesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.referencedBy(model.referencedBy);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RefResource.Builder> getReferencedBy() {
            List<RefResource.Builder> result = RefResourceListCopier.copyToBuilder(this.referencedBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferencedBy(Collection<RefResource.BuilderImpl> referencedBy) {
            this.referencedBy = RefResourceListCopier.copyFromBuilder(referencedBy);
        }

        @Override
        public final Builder referencedBy(Collection<RefResource> referencedBy) {
            this.referencedBy = RefResourceListCopier.copy(referencedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedBy(RefResource ... referencedBy) {
            this.referencedBy(Arrays.asList(referencedBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedBy(Consumer<RefResource.Builder> ... referencedBy) {
            this.referencedBy(Stream.of(referencedBy).map(c -> (RefResource)((RefResource.Builder)RefResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSegmentReferencesResponse build() {
            return new ListSegmentReferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EvidentlyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSegmentReferencesResponse> {
        public Builder nextToken(String var1);

        public Builder referencedBy(Collection<RefResource> var1);

        public Builder referencedBy(RefResource ... var1);

        public Builder referencedBy(Consumer<RefResource.Builder> ... var1);
    }
}

