/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.TreatmentToWeightMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OnlineAbConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OnlineAbConfig> {
    private static final SdkField<String> CONTROL_TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("controlTreatmentName").getter(OnlineAbConfig.getter(OnlineAbConfig::controlTreatmentName)).setter(OnlineAbConfig.setter(Builder::controlTreatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlTreatmentName").build()}).build();
    private static final SdkField<Map<String, Long>> TREATMENT_WEIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("treatmentWeights").getter(OnlineAbConfig.getter(OnlineAbConfig::treatmentWeights)).setter(OnlineAbConfig.setter(Builder::treatmentWeights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatmentWeights").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_TREATMENT_NAME_FIELD, TREATMENT_WEIGHTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OnlineAbConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String controlTreatmentName;
    private final Map<String, Long> treatmentWeights;

    private OnlineAbConfig(BuilderImpl builder) {
        this.controlTreatmentName = builder.controlTreatmentName;
        this.treatmentWeights = builder.treatmentWeights;
    }

    public final String controlTreatmentName() {
        return this.controlTreatmentName;
    }

    public final boolean hasTreatmentWeights() {
        return this.treatmentWeights != null && !(this.treatmentWeights instanceof SdkAutoConstructMap);
    }

    public final Map<String, Long> treatmentWeights() {
        return this.treatmentWeights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlTreatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTreatmentWeights() ? this.treatmentWeights() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineAbConfig)) {
            return false;
        }
        OnlineAbConfig other = (OnlineAbConfig)obj;
        return Objects.equals(this.controlTreatmentName(), other.controlTreatmentName()) && this.hasTreatmentWeights() == other.hasTreatmentWeights() && Objects.equals(this.treatmentWeights(), other.treatmentWeights());
    }

    public final String toString() {
        return ToString.builder((String)"OnlineAbConfig").add("ControlTreatmentName", (Object)this.controlTreatmentName()).add("TreatmentWeights", this.hasTreatmentWeights() ? this.treatmentWeights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlTreatmentName": {
                return Optional.ofNullable(clazz.cast(this.controlTreatmentName()));
            }
            case "treatmentWeights": {
                return Optional.ofNullable(clazz.cast(this.treatmentWeights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("controlTreatmentName", CONTROL_TREATMENT_NAME_FIELD);
        map.put("treatmentWeights", TREATMENT_WEIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OnlineAbConfig, T> g) {
        return obj -> g.apply((OnlineAbConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlTreatmentName;
        private Map<String, Long> treatmentWeights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OnlineAbConfig model) {
            this.controlTreatmentName(model.controlTreatmentName);
            this.treatmentWeights(model.treatmentWeights);
        }

        public final String getControlTreatmentName() {
            return this.controlTreatmentName;
        }

        public final void setControlTreatmentName(String controlTreatmentName) {
            this.controlTreatmentName = controlTreatmentName;
        }

        @Override
        public final Builder controlTreatmentName(String controlTreatmentName) {
            this.controlTreatmentName = controlTreatmentName;
            return this;
        }

        public final Map<String, Long> getTreatmentWeights() {
            if (this.treatmentWeights instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.treatmentWeights;
        }

        public final void setTreatmentWeights(Map<String, Long> treatmentWeights) {
            this.treatmentWeights = TreatmentToWeightMapCopier.copy(treatmentWeights);
        }

        @Override
        public final Builder treatmentWeights(Map<String, Long> treatmentWeights) {
            this.treatmentWeights = TreatmentToWeightMapCopier.copy(treatmentWeights);
            return this;
        }

        public OnlineAbConfig build() {
            return new OnlineAbConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OnlineAbConfig> {
        public Builder controlTreatmentName(String var1);

        public Builder treatmentWeights(Map<String, Long> var1);
    }
}

