/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FeatureStatus {
    AVAILABLE("AVAILABLE"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FeatureStatus> VALUE_MAP;
    private final String value;

    private FeatureStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FeatureStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FeatureStatus> knownValues() {
        EnumSet<FeatureStatus> knownValues = EnumSet.allOf(FeatureStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FeatureStatus.class, FeatureStatus::toString);
    }
}

