/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.evidently.model.ProjectAppConfigResource;
import software.amazon.awssdk.services.evidently.model.ProjectDataDelivery;
import software.amazon.awssdk.services.evidently.model.ProjectStatus;
import software.amazon.awssdk.services.evidently.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Project
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Project> {
    private static final SdkField<Long> ACTIVE_EXPERIMENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("activeExperimentCount").getter(Project.getter(Project::activeExperimentCount)).setter(Project.setter(Builder::activeExperimentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeExperimentCount").build()}).build();
    private static final SdkField<Long> ACTIVE_LAUNCH_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("activeLaunchCount").getter(Project.getter(Project::activeLaunchCount)).setter(Project.setter(Builder::activeLaunchCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeLaunchCount").build()}).build();
    private static final SdkField<ProjectAppConfigResource> APP_CONFIG_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appConfigResource").getter(Project.getter(Project::appConfigResource)).setter(Project.setter(Builder::appConfigResource)).constructor(ProjectAppConfigResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigResource").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Project.getter(Project::arn)).setter(Project.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(Project.getter(Project::createdTime)).setter(Project.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<ProjectDataDelivery> DATA_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataDelivery").getter(Project.getter(Project::dataDelivery)).setter(Project.setter(Builder::dataDelivery)).constructor(ProjectDataDelivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDelivery").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Project.getter(Project::description)).setter(Project.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Long> EXPERIMENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("experimentCount").getter(Project.getter(Project::experimentCount)).setter(Project.setter(Builder::experimentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("experimentCount").build()}).build();
    private static final SdkField<Long> FEATURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("featureCount").getter(Project.getter(Project::featureCount)).setter(Project.setter(Builder::featureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureCount").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedTime").getter(Project.getter(Project::lastUpdatedTime)).setter(Project.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<Long> LAUNCH_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("launchCount").getter(Project.getter(Project::launchCount)).setter(Project.setter(Builder::launchCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchCount").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Project.getter(Project::name)).setter(Project.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Project.getter(Project::statusAsString)).setter(Project.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Project.getter(Project::tags)).setter(Project.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_EXPERIMENT_COUNT_FIELD, ACTIVE_LAUNCH_COUNT_FIELD, APP_CONFIG_RESOURCE_FIELD, ARN_FIELD, CREATED_TIME_FIELD, DATA_DELIVERY_FIELD, DESCRIPTION_FIELD, EXPERIMENT_COUNT_FIELD, FEATURE_COUNT_FIELD, LAST_UPDATED_TIME_FIELD, LAUNCH_COUNT_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("activeExperimentCount", ACTIVE_EXPERIMENT_COUNT_FIELD);
            this.put("activeLaunchCount", ACTIVE_LAUNCH_COUNT_FIELD);
            this.put("appConfigResource", APP_CONFIG_RESOURCE_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("createdTime", CREATED_TIME_FIELD);
            this.put("dataDelivery", DATA_DELIVERY_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("experimentCount", EXPERIMENT_COUNT_FIELD);
            this.put("featureCount", FEATURE_COUNT_FIELD);
            this.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("launchCount", LAUNCH_COUNT_FIELD);
            this.put("name", NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long activeExperimentCount;
    private final Long activeLaunchCount;
    private final ProjectAppConfigResource appConfigResource;
    private final String arn;
    private final Instant createdTime;
    private final ProjectDataDelivery dataDelivery;
    private final String description;
    private final Long experimentCount;
    private final Long featureCount;
    private final Instant lastUpdatedTime;
    private final Long launchCount;
    private final String name;
    private final String status;
    private final Map<String, String> tags;

    private Project(BuilderImpl builder) {
        this.activeExperimentCount = builder.activeExperimentCount;
        this.activeLaunchCount = builder.activeLaunchCount;
        this.appConfigResource = builder.appConfigResource;
        this.arn = builder.arn;
        this.createdTime = builder.createdTime;
        this.dataDelivery = builder.dataDelivery;
        this.description = builder.description;
        this.experimentCount = builder.experimentCount;
        this.featureCount = builder.featureCount;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.launchCount = builder.launchCount;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final Long activeExperimentCount() {
        return this.activeExperimentCount;
    }

    public final Long activeLaunchCount() {
        return this.activeLaunchCount;
    }

    public final ProjectAppConfigResource appConfigResource() {
        return this.appConfigResource;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final ProjectDataDelivery dataDelivery() {
        return this.dataDelivery;
    }

    public final String description() {
        return this.description;
    }

    public final Long experimentCount() {
        return this.experimentCount;
    }

    public final Long featureCount() {
        return this.featureCount;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Long launchCount() {
        return this.launchCount;
    }

    public final String name() {
        return this.name;
    }

    public final ProjectStatus status() {
        return ProjectStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeExperimentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeLaunchCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.appConfigResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return Objects.equals(this.activeExperimentCount(), other.activeExperimentCount()) && Objects.equals(this.activeLaunchCount(), other.activeLaunchCount()) && Objects.equals(this.appConfigResource(), other.appConfigResource()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.dataDelivery(), other.dataDelivery()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.experimentCount(), other.experimentCount()) && Objects.equals(this.featureCount(), other.featureCount()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.launchCount(), other.launchCount()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Project").add("ActiveExperimentCount", (Object)this.activeExperimentCount()).add("ActiveLaunchCount", (Object)this.activeLaunchCount()).add("AppConfigResource", (Object)this.appConfigResource()).add("Arn", (Object)this.arn()).add("CreatedTime", (Object)this.createdTime()).add("DataDelivery", (Object)this.dataDelivery()).add("Description", (Object)this.description()).add("ExperimentCount", (Object)this.experimentCount()).add("FeatureCount", (Object)this.featureCount()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LaunchCount", (Object)this.launchCount()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "activeExperimentCount": {
                return Optional.ofNullable(clazz.cast(this.activeExperimentCount()));
            }
            case "activeLaunchCount": {
                return Optional.ofNullable(clazz.cast(this.activeLaunchCount()));
            }
            case "appConfigResource": {
                return Optional.ofNullable(clazz.cast(this.appConfigResource()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "dataDelivery": {
                return Optional.ofNullable(clazz.cast(this.dataDelivery()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "experimentCount": {
                return Optional.ofNullable(clazz.cast(this.experimentCount()));
            }
            case "featureCount": {
                return Optional.ofNullable(clazz.cast(this.featureCount()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "launchCount": {
                return Optional.ofNullable(clazz.cast(this.launchCount()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Project, T> g) {
        return obj -> g.apply((Project)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long activeExperimentCount;
        private Long activeLaunchCount;
        private ProjectAppConfigResource appConfigResource;
        private String arn;
        private Instant createdTime;
        private ProjectDataDelivery dataDelivery;
        private String description;
        private Long experimentCount;
        private Long featureCount;
        private Instant lastUpdatedTime;
        private Long launchCount;
        private String name;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.activeExperimentCount(model.activeExperimentCount);
            this.activeLaunchCount(model.activeLaunchCount);
            this.appConfigResource(model.appConfigResource);
            this.arn(model.arn);
            this.createdTime(model.createdTime);
            this.dataDelivery(model.dataDelivery);
            this.description(model.description);
            this.experimentCount(model.experimentCount);
            this.featureCount(model.featureCount);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.launchCount(model.launchCount);
            this.name(model.name);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final Long getActiveExperimentCount() {
            return this.activeExperimentCount;
        }

        public final void setActiveExperimentCount(Long activeExperimentCount) {
            this.activeExperimentCount = activeExperimentCount;
        }

        @Override
        public final Builder activeExperimentCount(Long activeExperimentCount) {
            this.activeExperimentCount = activeExperimentCount;
            return this;
        }

        public final Long getActiveLaunchCount() {
            return this.activeLaunchCount;
        }

        public final void setActiveLaunchCount(Long activeLaunchCount) {
            this.activeLaunchCount = activeLaunchCount;
        }

        @Override
        public final Builder activeLaunchCount(Long activeLaunchCount) {
            this.activeLaunchCount = activeLaunchCount;
            return this;
        }

        public final ProjectAppConfigResource.Builder getAppConfigResource() {
            return this.appConfigResource != null ? this.appConfigResource.toBuilder() : null;
        }

        public final void setAppConfigResource(ProjectAppConfigResource.BuilderImpl appConfigResource) {
            this.appConfigResource = appConfigResource != null ? appConfigResource.build() : null;
        }

        @Override
        public final Builder appConfigResource(ProjectAppConfigResource appConfigResource) {
            this.appConfigResource = appConfigResource;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final ProjectDataDelivery.Builder getDataDelivery() {
            return this.dataDelivery != null ? this.dataDelivery.toBuilder() : null;
        }

        public final void setDataDelivery(ProjectDataDelivery.BuilderImpl dataDelivery) {
            this.dataDelivery = dataDelivery != null ? dataDelivery.build() : null;
        }

        @Override
        public final Builder dataDelivery(ProjectDataDelivery dataDelivery) {
            this.dataDelivery = dataDelivery;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getExperimentCount() {
            return this.experimentCount;
        }

        public final void setExperimentCount(Long experimentCount) {
            this.experimentCount = experimentCount;
        }

        @Override
        public final Builder experimentCount(Long experimentCount) {
            this.experimentCount = experimentCount;
            return this;
        }

        public final Long getFeatureCount() {
            return this.featureCount;
        }

        public final void setFeatureCount(Long featureCount) {
            this.featureCount = featureCount;
        }

        @Override
        public final Builder featureCount(Long featureCount) {
            this.featureCount = featureCount;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Long getLaunchCount() {
            return this.launchCount;
        }

        public final void setLaunchCount(Long launchCount) {
            this.launchCount = launchCount;
        }

        @Override
        public final Builder launchCount(Long launchCount) {
            this.launchCount = launchCount;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProjectStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Project build() {
            return new Project(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Project> {
        public Builder activeExperimentCount(Long var1);

        public Builder activeLaunchCount(Long var1);

        public Builder appConfigResource(ProjectAppConfigResource var1);

        default public Builder appConfigResource(Consumer<ProjectAppConfigResource.Builder> appConfigResource) {
            return this.appConfigResource((ProjectAppConfigResource)((ProjectAppConfigResource.Builder)ProjectAppConfigResource.builder().applyMutation(appConfigResource)).build());
        }

        public Builder arn(String var1);

        public Builder createdTime(Instant var1);

        public Builder dataDelivery(ProjectDataDelivery var1);

        default public Builder dataDelivery(Consumer<ProjectDataDelivery.Builder> dataDelivery) {
            return this.dataDelivery((ProjectDataDelivery)((ProjectDataDelivery.Builder)ProjectDataDelivery.builder().applyMutation(dataDelivery)).build());
        }

        public Builder description(String var1);

        public Builder experimentCount(Long var1);

        public Builder featureCount(Long var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder launchCount(Long var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ProjectStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

