/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.ExperimentBaseStat;
import software.amazon.awssdk.services.evidently.model.ExperimentReportName;
import software.amazon.awssdk.services.evidently.model.ExperimentReportNameListCopier;
import software.amazon.awssdk.services.evidently.model.ExperimentResultRequestType;
import software.amazon.awssdk.services.evidently.model.ExperimentResultRequestTypeListCopier;
import software.amazon.awssdk.services.evidently.model.MetricNameListCopier;
import software.amazon.awssdk.services.evidently.model.TreatmentNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExperimentResultsRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, GetExperimentResultsRequest> {
    private static final SdkField<String> BASE_STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseStat").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::baseStatAsString)).setter(GetExperimentResultsRequest.setter(Builder::baseStat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseStat").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::endTime)).setter(GetExperimentResultsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> EXPERIMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("experiment").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::experiment)).setter(GetExperimentResultsRequest.setter(Builder::experiment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("experiment").build()}).build();
    private static final SdkField<List<String>> METRIC_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricNames").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::metricNames)).setter(GetExperimentResultsRequest.setter(Builder::metricNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("period").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::period)).setter(GetExperimentResultsRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::project)).setter(GetExperimentResultsRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final SdkField<List<String>> REPORT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportNames").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::reportNamesAsStrings)).setter(GetExperimentResultsRequest.setter(Builder::reportNamesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESULT_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resultStats").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::resultStatsAsStrings)).setter(GetExperimentResultsRequest.setter(Builder::resultStatsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultStats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::startTime)).setter(GetExperimentResultsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<List<String>> TREATMENT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("treatmentNames").getter(GetExperimentResultsRequest.getter(GetExperimentResultsRequest::treatmentNames)).setter(GetExperimentResultsRequest.setter(Builder::treatmentNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatmentNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_STAT_FIELD, END_TIME_FIELD, EXPERIMENT_FIELD, METRIC_NAMES_FIELD, PERIOD_FIELD, PROJECT_FIELD, REPORT_NAMES_FIELD, RESULT_STATS_FIELD, START_TIME_FIELD, TREATMENT_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("baseStat", BASE_STAT_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("experiment", EXPERIMENT_FIELD);
            this.put("metricNames", METRIC_NAMES_FIELD);
            this.put("period", PERIOD_FIELD);
            this.put("project", PROJECT_FIELD);
            this.put("reportNames", REPORT_NAMES_FIELD);
            this.put("resultStats", RESULT_STATS_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("treatmentNames", TREATMENT_NAMES_FIELD);
        }
    });
    private final String baseStat;
    private final Instant endTime;
    private final String experiment;
    private final List<String> metricNames;
    private final Long period;
    private final String project;
    private final List<String> reportNames;
    private final List<String> resultStats;
    private final Instant startTime;
    private final List<String> treatmentNames;

    private GetExperimentResultsRequest(BuilderImpl builder) {
        super(builder);
        this.baseStat = builder.baseStat;
        this.endTime = builder.endTime;
        this.experiment = builder.experiment;
        this.metricNames = builder.metricNames;
        this.period = builder.period;
        this.project = builder.project;
        this.reportNames = builder.reportNames;
        this.resultStats = builder.resultStats;
        this.startTime = builder.startTime;
        this.treatmentNames = builder.treatmentNames;
    }

    public final ExperimentBaseStat baseStat() {
        return ExperimentBaseStat.fromValue(this.baseStat);
    }

    public final String baseStatAsString() {
        return this.baseStat;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String experiment() {
        return this.experiment;
    }

    public final boolean hasMetricNames() {
        return this.metricNames != null && !(this.metricNames instanceof SdkAutoConstructList);
    }

    public final List<String> metricNames() {
        return this.metricNames;
    }

    public final Long period() {
        return this.period;
    }

    public final String project() {
        return this.project;
    }

    public final List<ExperimentReportName> reportNames() {
        return ExperimentReportNameListCopier.copyStringToEnum(this.reportNames);
    }

    public final boolean hasReportNames() {
        return this.reportNames != null && !(this.reportNames instanceof SdkAutoConstructList);
    }

    public final List<String> reportNamesAsStrings() {
        return this.reportNames;
    }

    public final List<ExperimentResultRequestType> resultStats() {
        return ExperimentResultRequestTypeListCopier.copyStringToEnum(this.resultStats);
    }

    public final boolean hasResultStats() {
        return this.resultStats != null && !(this.resultStats instanceof SdkAutoConstructList);
    }

    public final List<String> resultStatsAsStrings() {
        return this.resultStats;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final boolean hasTreatmentNames() {
        return this.treatmentNames != null && !(this.treatmentNames instanceof SdkAutoConstructList);
    }

    public final List<String> treatmentNames() {
        return this.treatmentNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baseStatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.experiment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricNames() ? this.metricNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportNames() ? this.reportNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultStats() ? this.resultStatsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTreatmentNames() ? this.treatmentNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExperimentResultsRequest)) {
            return false;
        }
        GetExperimentResultsRequest other = (GetExperimentResultsRequest)((Object)obj);
        return Objects.equals(this.baseStatAsString(), other.baseStatAsString()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.experiment(), other.experiment()) && this.hasMetricNames() == other.hasMetricNames() && Objects.equals(this.metricNames(), other.metricNames()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.project(), other.project()) && this.hasReportNames() == other.hasReportNames() && Objects.equals(this.reportNamesAsStrings(), other.reportNamesAsStrings()) && this.hasResultStats() == other.hasResultStats() && Objects.equals(this.resultStatsAsStrings(), other.resultStatsAsStrings()) && Objects.equals(this.startTime(), other.startTime()) && this.hasTreatmentNames() == other.hasTreatmentNames() && Objects.equals(this.treatmentNames(), other.treatmentNames());
    }

    public final String toString() {
        return ToString.builder((String)"GetExperimentResultsRequest").add("BaseStat", (Object)this.baseStatAsString()).add("EndTime", (Object)this.endTime()).add("Experiment", (Object)this.experiment()).add("MetricNames", this.hasMetricNames() ? this.metricNames() : null).add("Period", (Object)this.period()).add("Project", (Object)this.project()).add("ReportNames", this.hasReportNames() ? this.reportNamesAsStrings() : null).add("ResultStats", this.hasResultStats() ? this.resultStatsAsStrings() : null).add("StartTime", (Object)this.startTime()).add("TreatmentNames", this.hasTreatmentNames() ? this.treatmentNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseStat": {
                return Optional.ofNullable(clazz.cast(this.baseStatAsString()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "experiment": {
                return Optional.ofNullable(clazz.cast(this.experiment()));
            }
            case "metricNames": {
                return Optional.ofNullable(clazz.cast(this.metricNames()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "reportNames": {
                return Optional.ofNullable(clazz.cast(this.reportNamesAsStrings()));
            }
            case "resultStats": {
                return Optional.ofNullable(clazz.cast(this.resultStatsAsStrings()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "treatmentNames": {
                return Optional.ofNullable(clazz.cast(this.treatmentNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetExperimentResultsRequest, T> g) {
        return obj -> g.apply((GetExperimentResultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private String baseStat;
        private Instant endTime;
        private String experiment;
        private List<String> metricNames = DefaultSdkAutoConstructList.getInstance();
        private Long period;
        private String project;
        private List<String> reportNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> resultStats = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private List<String> treatmentNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetExperimentResultsRequest model) {
            super(model);
            this.baseStat(model.baseStat);
            this.endTime(model.endTime);
            this.experiment(model.experiment);
            this.metricNames(model.metricNames);
            this.period(model.period);
            this.project(model.project);
            this.reportNamesWithStrings(model.reportNames);
            this.resultStatsWithStrings(model.resultStats);
            this.startTime(model.startTime);
            this.treatmentNames(model.treatmentNames);
        }

        public final String getBaseStat() {
            return this.baseStat;
        }

        public final void setBaseStat(String baseStat) {
            this.baseStat = baseStat;
        }

        @Override
        public final Builder baseStat(String baseStat) {
            this.baseStat = baseStat;
            return this;
        }

        @Override
        public final Builder baseStat(ExperimentBaseStat baseStat) {
            this.baseStat(baseStat == null ? null : baseStat.toString());
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getExperiment() {
            return this.experiment;
        }

        public final void setExperiment(String experiment) {
            this.experiment = experiment;
        }

        @Override
        public final Builder experiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public final Collection<String> getMetricNames() {
            if (this.metricNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricNames;
        }

        public final void setMetricNames(Collection<String> metricNames) {
            this.metricNames = MetricNameListCopier.copy(metricNames);
        }

        @Override
        public final Builder metricNames(Collection<String> metricNames) {
            this.metricNames = MetricNameListCopier.copy(metricNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricNames(String ... metricNames) {
            this.metricNames(Arrays.asList(metricNames));
            return this;
        }

        public final Long getPeriod() {
            return this.period;
        }

        public final void setPeriod(Long period) {
            this.period = period;
        }

        @Override
        public final Builder period(Long period) {
            this.period = period;
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final Collection<String> getReportNames() {
            if (this.reportNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reportNames;
        }

        public final void setReportNames(Collection<String> reportNames) {
            this.reportNames = ExperimentReportNameListCopier.copy(reportNames);
        }

        @Override
        public final Builder reportNamesWithStrings(Collection<String> reportNames) {
            this.reportNames = ExperimentReportNameListCopier.copy(reportNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportNamesWithStrings(String ... reportNames) {
            this.reportNamesWithStrings(Arrays.asList(reportNames));
            return this;
        }

        @Override
        public final Builder reportNames(Collection<ExperimentReportName> reportNames) {
            this.reportNames = ExperimentReportNameListCopier.copyEnumToString(reportNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportNames(ExperimentReportName ... reportNames) {
            this.reportNames(Arrays.asList(reportNames));
            return this;
        }

        public final Collection<String> getResultStats() {
            if (this.resultStats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resultStats;
        }

        public final void setResultStats(Collection<String> resultStats) {
            this.resultStats = ExperimentResultRequestTypeListCopier.copy(resultStats);
        }

        @Override
        public final Builder resultStatsWithStrings(Collection<String> resultStats) {
            this.resultStats = ExperimentResultRequestTypeListCopier.copy(resultStats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultStatsWithStrings(String ... resultStats) {
            this.resultStatsWithStrings(Arrays.asList(resultStats));
            return this;
        }

        @Override
        public final Builder resultStats(Collection<ExperimentResultRequestType> resultStats) {
            this.resultStats = ExperimentResultRequestTypeListCopier.copyEnumToString(resultStats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultStats(ExperimentResultRequestType ... resultStats) {
            this.resultStats(Arrays.asList(resultStats));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Collection<String> getTreatmentNames() {
            if (this.treatmentNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.treatmentNames;
        }

        public final void setTreatmentNames(Collection<String> treatmentNames) {
            this.treatmentNames = TreatmentNameListCopier.copy(treatmentNames);
        }

        @Override
        public final Builder treatmentNames(Collection<String> treatmentNames) {
            this.treatmentNames = TreatmentNameListCopier.copy(treatmentNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder treatmentNames(String ... treatmentNames) {
            this.treatmentNames(Arrays.asList(treatmentNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetExperimentResultsRequest build() {
            return new GetExperimentResultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExperimentResultsRequest> {
        public Builder baseStat(String var1);

        public Builder baseStat(ExperimentBaseStat var1);

        public Builder endTime(Instant var1);

        public Builder experiment(String var1);

        public Builder metricNames(Collection<String> var1);

        public Builder metricNames(String ... var1);

        public Builder period(Long var1);

        public Builder project(String var1);

        public Builder reportNamesWithStrings(Collection<String> var1);

        public Builder reportNamesWithStrings(String ... var1);

        public Builder reportNames(Collection<ExperimentReportName> var1);

        public Builder reportNames(ExperimentReportName ... var1);

        public Builder resultStatsWithStrings(Collection<String> var1);

        public Builder resultStatsWithStrings(String ... var1);

        public Builder resultStats(Collection<ExperimentResultRequestType> var1);

        public Builder resultStats(ExperimentResultRequestType ... var1);

        public Builder startTime(Instant var1);

        public Builder treatmentNames(Collection<String> var1);

        public Builder treatmentNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

