/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExperimentBaseStat {
    MEAN("Mean"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExperimentBaseStat> VALUE_MAP;
    private final String value;

    private ExperimentBaseStat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentBaseStat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentBaseStat> knownValues() {
        EnumSet<ExperimentBaseStat> knownValues = EnumSet.allOf(ExperimentBaseStat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExperimentBaseStat.class, ExperimentBaseStat::toString);
    }
}

