/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evidently.EvidentlyAsyncClient;
import software.amazon.awssdk.services.evidently.internal.UserAgentUtils;
import software.amazon.awssdk.services.evidently.model.Launch;
import software.amazon.awssdk.services.evidently.model.ListLaunchesRequest;
import software.amazon.awssdk.services.evidently.model.ListLaunchesResponse;

public class ListLaunchesPublisher
implements SdkPublisher<ListLaunchesResponse> {
    private final EvidentlyAsyncClient client;
    private final ListLaunchesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLaunchesPublisher(EvidentlyAsyncClient client, ListLaunchesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLaunchesPublisher(EvidentlyAsyncClient client, ListLaunchesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLaunchesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLaunchesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Launch> launches() {
        Function<ListLaunchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.launches() != null) {
                return response.launches().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLaunchesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLaunchesResponseFetcher
    implements AsyncPageFetcher<ListLaunchesResponse> {
        private ListLaunchesResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLaunchesResponse> nextPage(ListLaunchesResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchesPublisher.this.client.listLaunches(ListLaunchesPublisher.this.firstRequest);
            }
            return ListLaunchesPublisher.this.client.listLaunches((ListLaunchesRequest)((Object)ListLaunchesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

