/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvidentlyRequest;
import software.amazon.awssdk.services.evidently.model.LaunchGroupConfig;
import software.amazon.awssdk.services.evidently.model.LaunchGroupConfigListCopier;
import software.amazon.awssdk.services.evidently.model.MetricMonitorConfig;
import software.amazon.awssdk.services.evidently.model.MetricMonitorConfigListCopier;
import software.amazon.awssdk.services.evidently.model.ScheduledSplitsLaunchConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLaunchRequest
extends EvidentlyRequest
implements ToCopyableBuilder<Builder, UpdateLaunchRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateLaunchRequest.getter(UpdateLaunchRequest::description)).setter(UpdateLaunchRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<LaunchGroupConfig>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groups").getter(UpdateLaunchRequest.getter(UpdateLaunchRequest::groups)).setter(UpdateLaunchRequest.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchGroupConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launch").getter(UpdateLaunchRequest.getter(UpdateLaunchRequest::launch)).setter(UpdateLaunchRequest.setter(Builder::launch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("launch").build()}).build();
    private static final SdkField<List<MetricMonitorConfig>> METRIC_MONITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metricMonitors").getter(UpdateLaunchRequest.getter(UpdateLaunchRequest::metricMonitors)).setter(UpdateLaunchRequest.setter(Builder::metricMonitors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricMonitors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricMonitorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("project").getter(UpdateLaunchRequest.getter(UpdateLaunchRequest::project)).setter(UpdateLaunchRequest.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("project").build()}).build();
    private static final SdkField<String> RANDOMIZATION_SALT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("randomizationSalt").getter(UpdateLaunchRequest.getter(UpdateLaunchRequest::randomizationSalt)).setter(UpdateLaunchRequest.setter(Builder::randomizationSalt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomizationSalt").build()}).build();
    private static final SdkField<ScheduledSplitsLaunchConfig> SCHEDULED_SPLITS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("scheduledSplitsConfig").getter(UpdateLaunchRequest.getter(UpdateLaunchRequest::scheduledSplitsConfig)).setter(UpdateLaunchRequest.setter(Builder::scheduledSplitsConfig)).constructor(ScheduledSplitsLaunchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledSplitsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, GROUPS_FIELD, LAUNCH_FIELD, METRIC_MONITORS_FIELD, PROJECT_FIELD, RANDOMIZATION_SALT_FIELD, SCHEDULED_SPLITS_CONFIG_FIELD));
    private final String description;
    private final List<LaunchGroupConfig> groups;
    private final String launch;
    private final List<MetricMonitorConfig> metricMonitors;
    private final String project;
    private final String randomizationSalt;
    private final ScheduledSplitsLaunchConfig scheduledSplitsConfig;

    private UpdateLaunchRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.groups = builder.groups;
        this.launch = builder.launch;
        this.metricMonitors = builder.metricMonitors;
        this.project = builder.project;
        this.randomizationSalt = builder.randomizationSalt;
        this.scheduledSplitsConfig = builder.scheduledSplitsConfig;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<LaunchGroupConfig> groups() {
        return this.groups;
    }

    public final String launch() {
        return this.launch;
    }

    public final boolean hasMetricMonitors() {
        return this.metricMonitors != null && !(this.metricMonitors instanceof SdkAutoConstructList);
    }

    public final List<MetricMonitorConfig> metricMonitors() {
        return this.metricMonitors;
    }

    public final String project() {
        return this.project;
    }

    public final String randomizationSalt() {
        return this.randomizationSalt;
    }

    public final ScheduledSplitsLaunchConfig scheduledSplitsConfig() {
        return this.scheduledSplitsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launch());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricMonitors() ? this.metricMonitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomizationSalt());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledSplitsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLaunchRequest)) {
            return false;
        }
        UpdateLaunchRequest other = (UpdateLaunchRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.launch(), other.launch()) && this.hasMetricMonitors() == other.hasMetricMonitors() && Objects.equals(this.metricMonitors(), other.metricMonitors()) && Objects.equals(this.project(), other.project()) && Objects.equals(this.randomizationSalt(), other.randomizationSalt()) && Objects.equals(this.scheduledSplitsConfig(), other.scheduledSplitsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLaunchRequest").add("Description", (Object)this.description()).add("Groups", this.hasGroups() ? this.groups() : null).add("Launch", (Object)this.launch()).add("MetricMonitors", this.hasMetricMonitors() ? this.metricMonitors() : null).add("Project", (Object)this.project()).add("RandomizationSalt", (Object)this.randomizationSalt()).add("ScheduledSplitsConfig", (Object)this.scheduledSplitsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "launch": {
                return Optional.ofNullable(clazz.cast(this.launch()));
            }
            case "metricMonitors": {
                return Optional.ofNullable(clazz.cast(this.metricMonitors()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "randomizationSalt": {
                return Optional.ofNullable(clazz.cast(this.randomizationSalt()));
            }
            case "scheduledSplitsConfig": {
                return Optional.ofNullable(clazz.cast(this.scheduledSplitsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLaunchRequest, T> g) {
        return obj -> g.apply((UpdateLaunchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<LaunchGroupConfig> groups = DefaultSdkAutoConstructList.getInstance();
        private String launch;
        private List<MetricMonitorConfig> metricMonitors = DefaultSdkAutoConstructList.getInstance();
        private String project;
        private String randomizationSalt;
        private ScheduledSplitsLaunchConfig scheduledSplitsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLaunchRequest model) {
            super(model);
            this.description(model.description);
            this.groups(model.groups);
            this.launch(model.launch);
            this.metricMonitors(model.metricMonitors);
            this.project(model.project);
            this.randomizationSalt(model.randomizationSalt);
            this.scheduledSplitsConfig(model.scheduledSplitsConfig);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<LaunchGroupConfig.Builder> getGroups() {
            List<LaunchGroupConfig.Builder> result = LaunchGroupConfigListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<LaunchGroupConfig.BuilderImpl> groups) {
            this.groups = LaunchGroupConfigListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<LaunchGroupConfig> groups) {
            this.groups = LaunchGroupConfigListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(LaunchGroupConfig ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<LaunchGroupConfig.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (LaunchGroupConfig)((LaunchGroupConfig.Builder)LaunchGroupConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLaunch() {
            return this.launch;
        }

        public final void setLaunch(String launch) {
            this.launch = launch;
        }

        @Override
        public final Builder launch(String launch) {
            this.launch = launch;
            return this;
        }

        public final List<MetricMonitorConfig.Builder> getMetricMonitors() {
            List<MetricMonitorConfig.Builder> result = MetricMonitorConfigListCopier.copyToBuilder(this.metricMonitors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricMonitors(Collection<MetricMonitorConfig.BuilderImpl> metricMonitors) {
            this.metricMonitors = MetricMonitorConfigListCopier.copyFromBuilder(metricMonitors);
        }

        @Override
        public final Builder metricMonitors(Collection<MetricMonitorConfig> metricMonitors) {
            this.metricMonitors = MetricMonitorConfigListCopier.copy(metricMonitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricMonitors(MetricMonitorConfig ... metricMonitors) {
            this.metricMonitors(Arrays.asList(metricMonitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricMonitors(Consumer<MetricMonitorConfig.Builder> ... metricMonitors) {
            this.metricMonitors(Stream.of(metricMonitors).map(c -> (MetricMonitorConfig)((MetricMonitorConfig.Builder)MetricMonitorConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProject() {
            return this.project;
        }

        public final void setProject(String project) {
            this.project = project;
        }

        @Override
        public final Builder project(String project) {
            this.project = project;
            return this;
        }

        public final String getRandomizationSalt() {
            return this.randomizationSalt;
        }

        public final void setRandomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
        }

        @Override
        public final Builder randomizationSalt(String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        public final ScheduledSplitsLaunchConfig.Builder getScheduledSplitsConfig() {
            return this.scheduledSplitsConfig != null ? this.scheduledSplitsConfig.toBuilder() : null;
        }

        public final void setScheduledSplitsConfig(ScheduledSplitsLaunchConfig.BuilderImpl scheduledSplitsConfig) {
            this.scheduledSplitsConfig = scheduledSplitsConfig != null ? scheduledSplitsConfig.build() : null;
        }

        @Override
        public final Builder scheduledSplitsConfig(ScheduledSplitsLaunchConfig scheduledSplitsConfig) {
            this.scheduledSplitsConfig = scheduledSplitsConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLaunchRequest build() {
            return new UpdateLaunchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLaunchRequest> {
        public Builder description(String var1);

        public Builder groups(Collection<LaunchGroupConfig> var1);

        public Builder groups(LaunchGroupConfig ... var1);

        public Builder groups(Consumer<LaunchGroupConfig.Builder> ... var1);

        public Builder launch(String var1);

        public Builder metricMonitors(Collection<MetricMonitorConfig> var1);

        public Builder metricMonitors(MetricMonitorConfig ... var1);

        public Builder metricMonitors(Consumer<MetricMonitorConfig.Builder> ... var1);

        public Builder project(String var1);

        public Builder randomizationSalt(String var1);

        public Builder scheduledSplitsConfig(ScheduledSplitsLaunchConfig var1);

        default public Builder scheduledSplitsConfig(Consumer<ScheduledSplitsLaunchConfig.Builder> scheduledSplitsConfig) {
            return this.scheduledSplitsConfig((ScheduledSplitsLaunchConfig)((ScheduledSplitsLaunchConfig.Builder)ScheduledSplitsLaunchConfig.builder().applyMutation(scheduledSplitsConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

