/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.evidently.EvidentlyClient;
import software.amazon.awssdk.services.evidently.internal.UserAgentUtils;
import software.amazon.awssdk.services.evidently.model.ListSegmentReferencesRequest;
import software.amazon.awssdk.services.evidently.model.ListSegmentReferencesResponse;
import software.amazon.awssdk.services.evidently.model.RefResource;

public class ListSegmentReferencesIterable
implements SdkIterable<ListSegmentReferencesResponse> {
    private final EvidentlyClient client;
    private final ListSegmentReferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSegmentReferencesIterable(EvidentlyClient client, ListSegmentReferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSegmentReferencesResponseFetcher();
    }

    public Iterator<ListSegmentReferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RefResource> referencedBy() {
        Function<ListSegmentReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.referencedBy() != null) {
                return response.referencedBy().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSegmentReferencesResponseFetcher
    implements SyncPageFetcher<ListSegmentReferencesResponse> {
        private ListSegmentReferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListSegmentReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSegmentReferencesResponse nextPage(ListSegmentReferencesResponse previousPage) {
            if (previousPage == null) {
                return ListSegmentReferencesIterable.this.client.listSegmentReferences(ListSegmentReferencesIterable.this.firstRequest);
            }
            return ListSegmentReferencesIterable.this.client.listSegmentReferences((ListSegmentReferencesRequest)((Object)ListSegmentReferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

