/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSegmentPatternRequest extends EvidentlyRequest implements
        ToCopyableBuilder<TestSegmentPatternRequest.Builder, TestSegmentPatternRequest> {
    private static final SdkField<String> PATTERN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pattern")
            .getter(getter(TestSegmentPatternRequest::pattern))
            .setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> PAYLOAD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("payload")
            .getter(getter(TestSegmentPatternRequest::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATTERN_FIELD, PAYLOAD_FIELD));

    private final String pattern;

    private final String payload;

    private TestSegmentPatternRequest(BuilderImpl builder) {
        super(builder);
        this.pattern = builder.pattern;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The pattern to test.
     * </p>
     * 
     * @return The pattern to test.
     */
    public final String pattern() {
        return pattern;
    }

    /**
     * <p>
     * A sample <code>evaluationContext</code> JSON block to test against the specified pattern.
     * </p>
     * 
     * @return A sample <code>evaluationContext</code> JSON block to test against the specified pattern.
     */
    public final String payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSegmentPatternRequest)) {
            return false;
        }
        TestSegmentPatternRequest other = (TestSegmentPatternRequest) obj;
        return Objects.equals(pattern(), other.pattern()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSegmentPatternRequest").add("Pattern", pattern()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestSegmentPatternRequest, T> g) {
        return obj -> g.apply((TestSegmentPatternRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, TestSegmentPatternRequest> {
        /**
         * <p>
         * The pattern to test.
         * </p>
         * 
         * @param pattern
         *        The pattern to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * A sample <code>evaluationContext</code> JSON block to test against the specified pattern.
         * </p>
         * 
         * @param payload
         *        A sample <code>evaluationContext</code> JSON block to test against the specified pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(String payload);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private String pattern;

        private String payload;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSegmentPatternRequest model) {
            super(model);
            pattern(model.pattern);
            payload(model.payload);
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final String getPayload() {
            return payload;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestSegmentPatternRequest build() {
            return new TestSegmentPatternRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
