/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSegmentReferencesResponse extends EvidentlyResponse implements
        ToCopyableBuilder<ListSegmentReferencesResponse.Builder, ListSegmentReferencesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSegmentReferencesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<RefResource>> REFERENCED_BY_FIELD = SdkField
            .<List<RefResource>> builder(MarshallingType.LIST)
            .memberName("referencedBy")
            .getter(getter(ListSegmentReferencesResponse::referencedBy))
            .setter(setter(Builder::referencedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referencedBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RefResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(RefResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REFERENCED_BY_FIELD));

    private final String nextToken;

    private final List<RefResource> referencedBy;

    private ListSegmentReferencesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.referencedBy = builder.referencedBy;
    }

    /**
     * <p>
     * The token to use in a subsequent <code>ListSegmentReferences</code> operation to return the next set of results.
     * </p>
     * 
     * @return The token to use in a subsequent <code>ListSegmentReferences</code> operation to return the next set of
     *         results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferencedBy property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferencedBy() {
        return referencedBy != null && !(referencedBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure contains information about one experiment or launch that uses this
     * segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferencedBy} method.
     * </p>
     * 
     * @return An array of structures, where each structure contains information about one experiment or launch that
     *         uses this segment.
     */
    public final List<RefResource> referencedBy() {
        return referencedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferencedBy() ? referencedBy() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSegmentReferencesResponse)) {
            return false;
        }
        ListSegmentReferencesResponse other = (ListSegmentReferencesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasReferencedBy() == other.hasReferencedBy()
                && Objects.equals(referencedBy(), other.referencedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSegmentReferencesResponse").add("NextToken", nextToken())
                .add("ReferencedBy", hasReferencedBy() ? referencedBy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "referencedBy":
            return Optional.ofNullable(clazz.cast(referencedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSegmentReferencesResponse, T> g) {
        return obj -> g.apply((ListSegmentReferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSegmentReferencesResponse> {
        /**
         * <p>
         * The token to use in a subsequent <code>ListSegmentReferences</code> operation to return the next set of
         * results.
         * </p>
         * 
         * @param nextToken
         *        The token to use in a subsequent <code>ListSegmentReferences</code> operation to return the next set
         *        of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of structures, where each structure contains information about one experiment or launch that uses
         * this segment.
         * </p>
         * 
         * @param referencedBy
         *        An array of structures, where each structure contains information about one experiment or launch that
         *        uses this segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedBy(Collection<RefResource> referencedBy);

        /**
         * <p>
         * An array of structures, where each structure contains information about one experiment or launch that uses
         * this segment.
         * </p>
         * 
         * @param referencedBy
         *        An array of structures, where each structure contains information about one experiment or launch that
         *        uses this segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedBy(RefResource... referencedBy);

        /**
         * <p>
         * An array of structures, where each structure contains information about one experiment or launch that uses
         * this segment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.evidently.model.RefResource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.evidently.model.RefResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.evidently.model.RefResource.Builder#build()} is called immediately and
         * its result is passed to {@link #referencedBy(List<RefResource>)}.
         * 
         * @param referencedBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.evidently.model.RefResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referencedBy(java.util.Collection<RefResource>)
         */
        Builder referencedBy(Consumer<RefResource.Builder>... referencedBy);
    }

    static final class BuilderImpl extends EvidentlyResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RefResource> referencedBy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSegmentReferencesResponse model) {
            super(model);
            nextToken(model.nextToken);
            referencedBy(model.referencedBy);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RefResource.Builder> getReferencedBy() {
            List<RefResource.Builder> result = RefResourceListCopier.copyToBuilder(this.referencedBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferencedBy(Collection<RefResource.BuilderImpl> referencedBy) {
            this.referencedBy = RefResourceListCopier.copyFromBuilder(referencedBy);
        }

        @Override
        public final Builder referencedBy(Collection<RefResource> referencedBy) {
            this.referencedBy = RefResourceListCopier.copy(referencedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedBy(RefResource... referencedBy) {
            referencedBy(Arrays.asList(referencedBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedBy(Consumer<RefResource.Builder>... referencedBy) {
            referencedBy(Stream.of(referencedBy).map(c -> RefResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSegmentReferencesResponse build() {
            return new ListSegmentReferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
